package com.hexagram2021.inheritable_coat_color.registry;

import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.platform.Services;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

import static com.hexagram2021.chromosomelib.ChromosomeLib.MODID;

public final class ICCGeneLoci {
	public static final class_6880<GeneLocus> MELANIN_ENZYME = registerHomologous("melanin_enzyme", 14, 0.000625D, 0.050000D);
	public static final class_6880<GeneLocus> URANIDIN_ENZYME = registerLeft("uranidin_enzyme", 3, 0.001750D, 0.031250D);
	public static final class_6880<GeneLocus> MELANIN_METABOLIC_ENZYME = registerHomologous("melanin_metabolic_enzyme", 5, 0.000250D, 0.003500D);
	public static final class_6880<GeneLocus> DILUTION = registerHomologous("dilution", 19, 0.001500D, 0.003500D);
	public static final class_6880<GeneLocus> PINK = registerHomologous("pink", 6, 0.000250D, 0.000250D);
	public static final class_6880<GeneLocus> ABNORMAL = registerHomologous("abnormal", 7, 0.000300D, 0.000275D);
	public static final class_6880<GeneLocus> HAIR_LENGTH = registerHomologous("hair_length", 19, 0.001250D, 0.001750D);
	public static final class_6880<GeneLocus> SRY = registerRight("sry", 8, 0.000250D, 0.000250D);

	private ICCGeneLoci() {
	}

	private static class_6880<GeneLocus> registerHomologous(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
		return Services.PLATFORM.registerGeneLocus(new class_2960(MODID, name), () -> GeneLocus.homologous(index, possibilityOfMutation, possibilityOfCrossingOver));
	}

	@SuppressWarnings("SameParameterValue")
	private static class_6880<GeneLocus> registerLeft(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
		return Services.PLATFORM.registerGeneLocus(new class_2960(MODID, name), () -> GeneLocus.left(index, possibilityOfMutation, possibilityOfCrossingOver));
	}

	@SuppressWarnings("SameParameterValue")
	private static class_6880<GeneLocus> registerRight(String name, int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
		return Services.PLATFORM.registerGeneLocus(new class_2960(MODID, name), () -> GeneLocus.right(index, possibilityOfMutation, possibilityOfCrossingOver));
	}

	public static void init() {
		// Lazy init
	}
}
