package com.hexagram2021.inheritable_coat_color.registry;

import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.inheritable_coat_color.common.trait.CoatColorTrait;
import com.hexagram2021.inheritable_coat_color.common.trait.HairLengthTrait;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

import static com.hexagram2021.chromosomelib.ChromosomeLib.MODID;

public final class ICCTraits {
	public static final class_6880<Trait> BLACK = registerColorTrait("black", class_1767.field_7963);
	public static final class_6880<Trait> BLUE = registerColorTrait("blue", class_1767.field_7966);
	public static final class_6880<Trait> BROWN = registerColorTrait("brown", class_1767.field_7957);
	public static final class_6880<Trait> CYAN = registerColorTrait("cyan", class_1767.field_7955);
	public static final class_6880<Trait> GRAY = registerColorTrait("gray", class_1767.field_7944);
	public static final class_6880<Trait> GREEN = registerColorTrait("green", class_1767.field_7942);
	public static final class_6880<Trait> LIGHT_BLUE = registerColorTrait("light_blue", class_1767.field_7951);
	public static final class_6880<Trait> LIGHT_GRAY = registerColorTrait("light_gray", class_1767.field_7967);
	public static final class_6880<Trait> LIME = registerColorTrait("lime", class_1767.field_7961);
	public static final class_6880<Trait> MAGENTA = registerColorTrait("magenta", class_1767.field_7958);
	public static final class_6880<Trait> ORANGE = registerColorTrait("orange", class_1767.field_7946);
	public static final class_6880<Trait> PINK = registerColorTrait("pink", class_1767.field_7954);
	public static final class_6880<Trait> PURPLE = registerColorTrait("purple", class_1767.field_7945);
	public static final class_6880<Trait> RED = registerColorTrait("red", class_1767.field_7964);
	public static final class_6880<Trait> WHITE = registerColorTrait("white", class_1767.field_7952);
	public static final class_6880<Trait> YELLOW = registerColorTrait("yellow", class_1767.field_7947);

	public static final class_6880<Trait> SHORT_HAIR = registerHairLengthTrait("short_hair", false);
	public static final class_6880<Trait> LONG_HAIR = registerHairLengthTrait("long_hair", true);

	private ICCTraits() {
	}

	private static class_6880<Trait> registerColorTrait(String code, class_1767 color) {
		return Services.PLATFORM.registerTrait(new class_2960(MODID, code), () -> new CoatColorTrait(color));
	}

	private static class_6880<Trait> registerHairLengthTrait(String code, boolean longHair) {
		return Services.PLATFORM.registerTrait(new class_2960(MODID, code), () -> new HairLengthTrait(longHair));
	}

	public static void init() {
		// Lazy init
	}
}
