package de.keksuccino.drippyloadingscreen.customization.backgrounds.color;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import org.jetbrains.annotations.NotNull;
import java.awt.*;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_425;
import net.minecraft.class_5253;

public class ColorMenuBackground extends MenuBackground {

    @NotNull
    public DrawableColor color = DrawableColor.of(new Color(253, 87, 87));

    public ColorMenuBackground(MenuBackgroundBuilder<ColorMenuBackground> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        RenderingUtils.resetShaderColor(graphics);
        int colorToRender = class_5253.class_5254.method_27764(255, this.color.getColor().getRed(), this.color.getColor().getGreen(), this.color.getColor().getBlue());
        colorToRender = replaceAlpha(colorToRender, (int)(this.opacity * 255.0F));
        if (class_310.method_1551().method_18506() instanceof class_425) {
            graphics.method_51739(class_1921.method_51785(), 0, 0, getScreenWidth(), getScreenHeight(), colorToRender);
        } else {
            graphics.method_25294(0, 0, getScreenWidth(), getScreenHeight(), colorToRender);
        }
        RenderingUtils.resetShaderColor(graphics);

    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) alpha = 255;
        if (alpha < 0) alpha = 0;
        return color & 16777215 | alpha << 24;
    }

}
