/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.elements.vanillabar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VanillaBarElement
extends AbstractElement {
    @NotNull
    public DrawableColor color = DrawableColor.WHITE;

    public VanillaBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        int w = this.getAbsoluteWidth();
        int h = this.getAbsoluteHeight();
        float currentProgress = 0.5f;
        if (Minecraft.m_91087_().m_91265_() instanceof LoadingOverlay) {
            currentProgress = ((IMixinLoadingOverlay)Minecraft.m_91087_().m_91265_()).getCurrentProgressDrippy();
        }
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.drawProgressBar(graphics, x, y, x + w, y + h, currentProgress);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    protected void drawProgressBar(GuiGraphics graphics, int xMin, int yMin, int xMax, int yMax, float currentProgress) {
        int i = Mth.m_14167_((float)((float)(xMax - xMin - 2) * currentProgress));
        int k = VanillaBarElement.mergeOpacity(this.color.getColorInt(), this.opacity);
        graphics.fill(xMin + 2, yMin + 2, xMin + i, yMax - 2, k);
        graphics.fill(xMin + 1, yMin, xMax - 1, yMin + 1, k);
        graphics.fill(xMin + 1, yMax, xMax - 1, yMax - 1, k);
        graphics.fill(xMin, yMin, xMin + 1, yMax, k);
        graphics.fill(xMax, yMin, xMax - 1, yMax, k);
    }

    private static int mergeOpacity(int color, float opacity) {
        float op = Math.max(0.0f, Math.min(1.0f, opacity));
        int originalAlpha = color >>> 24 & 0xFF;
        int newAlpha = Math.round((float)originalAlpha * op);
        int MIN_ALPHA = Math.round(5.1f);
        newAlpha = Math.max(MIN_ALPHA, Math.min(255, newAlpha));
        return color & 0xFFFFFF | newAlpha << 24;
    }
}

