package de.keksuccino.drippyloadingscreen.customization.backgrounds.color;

import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ColorMenuBackgroundBuilder extends MenuBackgroundBuilder<ColorMenuBackground> {

    public ColorMenuBackgroundBuilder() {
        super("drippy_color_background");
    }

    @Override
    public void buildNewOrEditInstance(class_437 currentScreen, @Nullable ColorMenuBackground backgroundToEdit, @NotNull Consumer<ColorMenuBackground> backgroundConsumer) {
        ColorMenuBackground back = (backgroundToEdit != null) ? (ColorMenuBackground) backgroundToEdit.copy() : null;
        if (back == null) {
            back = new ColorMenuBackground(this);
        }
        ColorMenuBackgroundConfigScreen s = new ColorMenuBackgroundConfigScreen(back, background -> {
           if (background != null) {
               backgroundConsumer.accept(background);
           } else {
               backgroundConsumer.accept(backgroundToEdit);
           }
           class_310.method_1551().method_1507(currentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    @Override
    public ColorMenuBackground deserializeBackground(SerializedMenuBackground serializedMenuBackground) {

        ColorMenuBackground b = new ColorMenuBackground(this);

        String hex = serializedMenuBackground.getValue("color");
        if (hex != null) b.color = DrawableColor.of(hex);

        return b;

    }

    @Override
    public SerializedMenuBackground serializedBackground(ColorMenuBackground background) {

        SerializedMenuBackground serialized = new SerializedMenuBackground();

        serialized.putProperty("color", background.color.getHex());

        return serialized;

    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("drippyloadingscreen.background.color");
    }

    @Override
    public @Nullable class_2561[] getDescription() {
        return LocalizationUtils.splitLocalizedLines("drippyloadingscreen.background.color.desc");
    }

}
