/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization;

import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DrippyOverlayScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MOJANG_STUDIOS_LOGO_LOCATION = ResourceLocation.parse((String)"textures/gui/title/mojangstudios.png");
    public float backgroundOpacity = 1.0f;

    public DrippyOverlayScreen() {
        super((Component)Component.empty());
        MixinCache.cachedCurrentLoadingScreenProgress = 0.5f;
        this.forceEnableCustomizations();
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((Screen)this)) {
            LOGGER.info("[DRIPPY LOADING SCREEN] Force-enabling customizations for DrippyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((Screen)this, (boolean)true);
        }
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)DrippyOverlayScreen.buildLogoWidget());
        this.addRenderableWidget((GuiEventListener)DrippyOverlayScreen.buildProgressBarWidget());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        int color;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen((Screen)this);
        boolean shouldRenderDefaultBackground = layer == null || layer.layoutBase.menuBackgrounds.isEmpty();
        IntSupplier supplier = IMixinLoadingOverlay.getBrandBackgroundDrippy();
        int n = color = supplier != null ? supplier.getAsInt() : 0;
        if (shouldRenderDefaultBackground) {
            graphics.fill(RenderType.guiOverlay(), 0, 0, this.width, this.height, DrippyOverlayScreen.replaceAlpha(color, (int)(this.backgroundOpacity * 255.0f)));
        }
        EventHandler.INSTANCE.postEvent((EventBase)new RenderedScreenBackgroundEvent((Screen)this, graphics));
    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) {
            alpha = 255;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        return color & 0xFFFFFF | alpha << 24;
    }

    public static RendererWidget buildLogoWidget() {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int centerX = (int)((double)screenWidth * 0.5);
        int centerY = (int)((double)screenHeight * 0.5);
        double logoHeight = Math.min((double)mc.getWindow().getGuiScaledWidth() * 0.75, (double)mc.getWindow().getGuiScaledHeight()) * 0.25;
        int logoHeightHalf = (int)(logoHeight * 0.5);
        double logoWidth = logoHeight * 4.0;
        int logoWidthHalf = (int)(logoWidth * 0.5);
        int logoPosX = centerX - logoWidthHalf;
        int logoPosY = centerY - logoHeightHalf;
        return new RendererWidget(logoPosX, logoPosY, logoWidthHalf * 2, logoHeightHalf * 2, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            int v = ARGB.white((float)((IMixinAbstractWidget)widget).getAlphaFancyMenu());
            graphics.blit(location -> RenderType.mojangLogo(), MOJANG_STUDIOS_LOGO_LOCATION, x, y, -0.0625f, 0.0f, width / 2, height, 120, 60, 120, 120, v);
            graphics.blit(location -> RenderType.mojangLogo(), MOJANG_STUDIOS_LOGO_LOCATION, x + width / 2, y, 0.0625f, 60.0f, width / 2, height, 120, 60, 120, 120, v);
        }).setWidgetIdentifierFancyMenu("mojang_logo");
    }

    public static RendererWidget buildProgressBarWidget() {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        double someDouble1 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double someDouble2 = someDouble1 * 4.0;
        int someInt1 = (int)(someDouble2 * 0.5);
        int someInt2 = (int)((double)screenHeight * 0.8325);
        int barPosX = screenWidth / 2 - someInt1;
        int barPosY = someInt2 - 5;
        int barWidth = someInt1 * 2;
        int barHeight = 10;
        return new RendererWidget(barPosX, barPosY, barWidth, barHeight, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            float currentProgress = 0.5f;
            if (Minecraft.getInstance().getOverlay() instanceof LoadingOverlay) {
                currentProgress = ((IMixinLoadingOverlay)Minecraft.getInstance().getOverlay()).getCurrentProgressDrippy();
            }
            DrippyOverlayScreen.drawProgressBar(graphics, x, y, x + width, y + height, ((IMixinAbstractWidget)widget).getAlphaFancyMenu(), currentProgress);
        }).setWidgetIdentifierFancyMenu("progress_bar");
    }

    private static void drawProgressBar(GuiGraphics graphics, int xMin, int yMin, int xMax, int yMax, float opacity, float currentProgress) {
        int i = Mth.ceil((float)((float)(xMax - xMin - 2) * currentProgress));
        int j = Math.round(opacity * 255.0f);
        int k = ARGB.color((int)j, (int)255, (int)255, (int)255);
        graphics.fill(xMin + 2, yMin + 2, xMin + i, yMax - 2, k);
        graphics.fill(xMin + 1, yMin, xMax - 1, yMin + 1, k);
        graphics.fill(xMin + 1, yMax, xMax - 1, yMax - 1, k);
        graphics.fill(xMin, yMin, xMin + 1, yMax, k);
        graphics.fill(xMax, yMin, xMax - 1, yMax, k);
    }
}

