/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.ARGB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public class MixinLoadingOverlay {
    @Unique
    private static final Logger LOGGER_DRIPPY = LogManager.getLogger();
    @Unique
    private static DrippyOverlayScreen drippyOverlayScreen = null;
    @Unique
    private int lastScreenWidthDrippy = 0;
    @Unique
    private int lastScreenHeightDrippy = 0;
    @Unique
    private float cachedBackgroundOpacityDrippy = 1.0f;
    @Unique
    private float cachedElementOpacityDrippy = 1.0f;
    @Unique
    private double cachedOverlayScaleDrippy = 1.0;
    @Unique
    private boolean fontsReloadedDrippy = false;
    @Shadow
    private float currentProgress;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void afterConstructDrippy(Minecraft mc, ReloadInstance reload, Consumer<?> consumer, boolean b, CallbackInfo info) {
        this.setNewOverlayScreenDrippy();
        this.lastScreenWidthDrippy = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.lastScreenHeightDrippy = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.initOverlayScreenDrippy(false);
        this.setBackgroundOpacityDrippy(1.0f);
        this.setElementsOpacityDrippy(1.0f);
        this.tickOverlayUpdateDrippy();
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void after_render_Drippy(GuiGraphics graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (this.shouldRenderVanillaDrippy()) {
            return;
        }
        if (!this.fontsReloadedDrippy) {
            LOGGER_DRIPPY.info("[DRIPPY LOADING SCREEN] Reloading fonts for text rendering..");
            this.loadFontsDrippy();
            this.fontsReloadedDrippy = true;
        }
        if (!this.fontsReadyDrippy(graphics)) {
            return;
        }
        RenderSystem.enableBlend();
        MixinCache.cachedCurrentLoadingScreenProgress = this.currentProgress;
        this.tickOverlayUpdateDrippy();
        this.setBackgroundOpacityDrippy(this.cachedBackgroundOpacityDrippy);
        this.setElementsOpacityDrippy((Boolean)DrippyLoadingScreen.getOptions().earlyFadeOutElements.getValue() != false ? this.cachedElementOpacityDrippy : this.cachedBackgroundOpacityDrippy);
        this.runMenuHandlerTaskDrippy(() -> {
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Pre((Screen)MixinLoadingOverlay.getDrippyOverlayScreen()));
            MixinLoadingOverlay.getDrippyOverlayScreen().tick();
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Post((Screen)MixinLoadingOverlay.getDrippyOverlayScreen()));
            Window window = Minecraft.getInstance().getWindow();
            double guiScale = window.getGuiScale();
            this.setGuiScaleDrippy(this.cachedOverlayScaleDrippy);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Pre((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), graphics, mouseX, mouseY, partial));
            MixinLoadingOverlay.getDrippyOverlayScreen().render(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Post((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), graphics, mouseX, mouseY, partial));
            this.setGuiScaleDrippy(guiScale);
        });
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    private boolean cancelScreenRenderingDrippy(Screen instance, GuiGraphics guiGraphics, int i, int j, float f) {
        return (Boolean)DrippyLoadingScreen.getOptions().fadeOutLoadingScreen.getValue();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    private void beforeCloseOverlayDrippy(GuiGraphics $$0, int $$1, int $$2, float $$3, CallbackInfo ci) {
        EventHandler.INSTANCE.postEvent((EventBase)new CloseScreenEvent((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), null));
    }

    @Inject(method={"drawProgressBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelOriginalProgressBarRenderingDrippy(GuiGraphics graphics, int p_96184_, int p_96185_, int p_96186_, int p_96187_, float opacity, CallbackInfo info) {
        if (!this.shouldRenderVanillaDrippy()) {
            info.cancel();
            this.cachedElementOpacityDrippy = (Boolean)DrippyLoadingScreen.getOptions().fadeOutLoadingScreen.getValue() != false ? Math.min(1.0f, Math.max(0.05f, opacity)) : 1.0f;
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIIII)V")})
    private boolean cancelOriginalLogoRenderingDrippy(GuiGraphics instance, Function<ResourceLocation, RenderType> $$0, ResourceLocation $$1, int $$2, int $$3, float $$4, float $$5, int $$6, int $$7, int $$8, int $$9, int $$10, int $$11, int $$12) {
        return this.shouldRenderVanillaDrippy();
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V")})
    private boolean cancelBackgroundRenderingDrippy(GuiGraphics instance, RenderType renderType, int i, int j, int k, int l, int color) {
        this.cachedBackgroundOpacityDrippy = (Boolean)DrippyLoadingScreen.getOptions().fadeOutLoadingScreen.getValue() != false ? Math.min(1.0f, Math.max(0.05f, (float)ARGB.alpha((int)color) / 255.0f)) : 1.0f;
        return this.shouldRenderVanillaDrippy();
    }

    @Unique
    private void setGuiScaleDrippy(double scale) {
        Window window = Minecraft.getInstance().getWindow();
        window.setGuiScale(scale);
        Minecraft.getInstance().gameRenderer.resize(window.getWidth(), window.getHeight());
        RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        RenderSystem.clear((int)256);
    }

    @Unique
    private boolean shouldRenderVanillaDrippy() {
        return MixinLoadingOverlay.getDrippyOverlayScreen() == null || this.getLayerDrippy() == null;
    }

    @Unique
    private void setBackgroundOpacityDrippy(float opacity) {
        if (this.getLayerDrippy() == null) {
            return;
        }
        this.getLayerDrippy().backgroundOpacity = opacity;
        MixinLoadingOverlay.getDrippyOverlayScreen().backgroundOpacity = opacity;
    }

    @Unique
    private void setElementsOpacityDrippy(float opacity) {
        if (opacity < 0.02f) {
            opacity = 0.02f;
        }
        if (this.getLayerDrippy() != null) {
            for (AbstractElement i : this.getLayerDrippy().allElements) {
                i.opacity = opacity;
                if (!(i.opacity <= 0.02f)) continue;
                i.visible = false;
            }
        }
    }

    @Unique
    @Nullable
    private ScreenCustomizationLayer getLayerDrippy() {
        if (MixinLoadingOverlay.getDrippyOverlayScreen() == null) {
            return null;
        }
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen((Screen)MixinLoadingOverlay.getDrippyOverlayScreen());
        if (l != null) {
            l.loadEarly = true;
        }
        return l;
    }

    @Unique
    private void loadFontsDrippy() {
        try {
            FontManager fontManager = ((IMixinMinecraft)Minecraft.getInstance()).getFontManagerDrippy();
            fontManager.reload(new PreparableReloadListener.PreparationBarrier(this){

                public <T> CompletableFuture<T> wait(T t) {
                    return new CompletableFuture();
                }
            }, Minecraft.getInstance().getResourceManager(), (Executor)Minecraft.getInstance(), (Executor)Util.backgroundExecutor());
        }
        catch (Exception ex) {
            LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Failed to load fonts!", (Throwable)ex);
        }
    }

    @Unique
    private boolean fontsReadyDrippy(GuiGraphics graphics) {
        try {
            Minecraft.getInstance().getShaderManager().getProgramForLoading(CoreShaders.RENDERTYPE_TEXT);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Unique
    private void tickOverlayUpdateDrippy() {
        try {
            int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            if (screenWidth != this.lastScreenWidthDrippy || screenHeight != this.lastScreenHeightDrippy) {
                this.initOverlayScreenDrippy(true);
            }
            this.lastScreenWidthDrippy = screenWidth;
            this.lastScreenHeightDrippy = screenHeight;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Unique
    private void setNewOverlayScreenDrippy() {
        drippyOverlayScreen = null;
        ScreenCustomizationLayerHandler.registerScreen((Screen)MixinLoadingOverlay.getDrippyOverlayScreen());
        this.getLayerDrippy();
    }

    @Unique
    private void initOverlayScreenDrippy(boolean resize) {
        this.runMenuHandlerTaskDrippy(() -> {
            try {
                double scale = Minecraft.getInstance().getWindow().getGuiScale();
                RenderingUtils.resetGuiScale();
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenEvent((Screen)MixinLoadingOverlay.getDrippyOverlayScreen()));
                }
                MixinLoadingOverlay.getDrippyOverlayScreen().width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                MixinLoadingOverlay.getDrippyOverlayScreen().height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenStartingEvent((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Pre((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                MixinLoadingOverlay.getDrippyOverlayScreen().init(Minecraft.getInstance(), MixinLoadingOverlay.getDrippyOverlayScreen().width, MixinLoadingOverlay.getDrippyOverlayScreen().height);
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Post((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenCompletedEvent((Screen)MixinLoadingOverlay.getDrippyOverlayScreen(), resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenPostInitEvent((Screen)MixinLoadingOverlay.getDrippyOverlayScreen()));
                }
                MixinCache.cachedLoadingOverlayScale = this.cachedOverlayScaleDrippy = Minecraft.getInstance().getWindow().getGuiScale();
                Minecraft.getInstance().getWindow().setGuiScale(scale);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Unique
    private void runMenuHandlerTaskDrippy(Runnable run) {
        try {
            boolean customizationEnabled = ScreenCustomization.isScreenCustomizationEnabled();
            ScreenCustomization.setScreenCustomizationEnabled((boolean)true);
            Screen current = Minecraft.getInstance().screen;
            if (!(current instanceof DrippyOverlayScreen)) {
                Minecraft.getInstance().screen = MixinLoadingOverlay.getDrippyOverlayScreen();
                run.run();
                Minecraft.getInstance().screen = current;
            }
            ScreenCustomization.setScreenCustomizationEnabled((boolean)customizationEnabled);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Unique
    private static DrippyOverlayScreen getDrippyOverlayScreen() {
        if (drippyOverlayScreen == null) {
            LOGGER_DRIPPY.info("[DRIPPY LOADING SCREEN] Creating DrippyOverlayScreen instance..");
            drippyOverlayScreen = new DrippyOverlayScreen();
        }
        return drippyOverlayScreen;
    }
}

