/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization;

import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import java.util.function.IntSupplier;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_9848;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DrippyOverlayScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 MOJANG_STUDIOS_LOGO_LOCATION = class_2960.method_60654((String)"textures/gui/title/mojangstudios.png");
    public float backgroundOpacity = 1.0f;

    public DrippyOverlayScreen() {
        super((class_2561)class_2561.method_43473());
        MixinCache.cachedCurrentLoadingScreenProgress = 0.5f;
        this.forceEnableCustomizations();
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((class_437)this)) {
            LOGGER.info("[DRIPPY LOADING SCREEN] Force-enabling customizations for DrippyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((class_437)this, (boolean)true);
        }
    }

    protected void method_25426() {
        this.method_37063((class_364)DrippyOverlayScreen.buildLogoWidget());
        this.method_37063((class_364)DrippyOverlayScreen.buildProgressBarWidget());
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        int color;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen((class_437)this);
        boolean shouldRenderDefaultBackground = layer == null || layer.layoutBase.menuBackgrounds.isEmpty();
        IntSupplier supplier = IMixinLoadingOverlay.getBrandBackgroundDrippy();
        int n = color = supplier != null ? supplier.getAsInt() : 0;
        if (shouldRenderDefaultBackground) {
            graphics.method_25294(0, 0, this.field_22789, this.field_22790, DrippyOverlayScreen.replaceAlpha(color, (int)(this.backgroundOpacity * 255.0f)));
        }
        EventHandler.INSTANCE.postEvent((EventBase)new RenderedScreenBackgroundEvent((class_437)this, graphics));
    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) {
            alpha = 255;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        return color & 0xFFFFFF | alpha << 24;
    }

    public static RendererWidget buildLogoWidget() {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int centerX = (int)((double)screenWidth * 0.5);
        int centerY = (int)((double)screenHeight * 0.5);
        double logoHeight = Math.min((double)mc.method_22683().method_4486() * 0.75, (double)mc.method_22683().method_4502()) * 0.25;
        int logoHeightHalf = (int)(logoHeight * 0.5);
        double logoWidth = logoHeight * 4.0;
        int logoWidthHalf = (int)(logoWidth * 0.5);
        int logoPosX = centerX - logoWidthHalf;
        int logoPosY = centerY - logoHeightHalf;
        return new RendererWidget(logoPosX, logoPosY, logoWidthHalf * 2, logoHeightHalf * 2, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            int v = class_9848.method_61317((float)((IMixinAbstractWidget)widget).getAlphaFancyMenu());
            graphics.method_25293(class_10799.field_56839, MOJANG_STUDIOS_LOGO_LOCATION, x, y, -0.0625f, 0.0f, width / 2, height, 120, 60, 120, 120, v);
            graphics.method_25293(class_10799.field_56839, MOJANG_STUDIOS_LOGO_LOCATION, x + width / 2, y, 0.0625f, 60.0f, width / 2, height, 120, 60, 120, 120, v);
        }).setWidgetIdentifierFancyMenu("mojang_logo");
    }

    public static RendererWidget buildProgressBarWidget() {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        double someDouble1 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double someDouble2 = someDouble1 * 4.0;
        int someInt1 = (int)(someDouble2 * 0.5);
        int someInt2 = (int)((double)screenHeight * 0.8325);
        int barPosX = screenWidth / 2 - someInt1;
        int barPosY = someInt2 - 5;
        int barWidth = someInt1 * 2;
        int barHeight = 10;
        return new RendererWidget(barPosX, barPosY, barWidth, barHeight, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            float currentProgress = 0.5f;
            if (class_310.method_1551().method_18506() instanceof class_425) {
                currentProgress = ((IMixinLoadingOverlay)class_310.method_1551().method_18506()).getCurrentProgressDrippy();
            }
            DrippyOverlayScreen.drawProgressBar(graphics, x, y, x + width, y + height, ((IMixinAbstractWidget)widget).getAlphaFancyMenu(), currentProgress);
        }).setWidgetIdentifierFancyMenu("progress_bar");
    }

    private static void drawProgressBar(class_332 graphics, int xMin, int yMin, int xMax, int yMax, float opacity, float currentProgress) {
        int i = class_3532.method_15386((float)((float)(xMax - xMin - 2) * currentProgress));
        int j = Math.round(opacity * 255.0f);
        int k = class_9848.method_61324((int)j, (int)255, (int)255, (int)255);
        graphics.method_25294(xMin + 2, yMin + 2, xMin + i, yMax - 2, k);
        graphics.method_25294(xMin + 1, yMin, xMax - 1, yMin + 1, k);
        graphics.method_25294(xMin + 1, yMax, xMax - 1, yMax - 1, k);
        graphics.method_25294(xMin, yMin, xMin + 1, yMax, k);
        graphics.method_25294(xMax, yMin, xMax - 1, yMax, k);
    }
}

