package de.keksuccino.drippyloadingscreen.customization.backgrounds.color;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import org.jetbrains.annotations.NotNull;
import java.awt.*;
import net.minecraft.class_332;
import net.minecraft.class_9848;

public class ColorMenuBackground extends MenuBackground {

    @NotNull
    public DrawableColor color = DrawableColor.of(new Color(253, 87, 87));

    public ColorMenuBackground(MenuBackgroundBuilder<ColorMenuBackground> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        int colorToRender = class_9848.method_61324(255, this.color.getColor().getRed(), this.color.getColor().getGreen(), this.color.getColor().getBlue());
        colorToRender = replaceAlpha(colorToRender, (int)(this.opacity * 255.0F));
        graphics.method_25294(0, 0, getScreenWidth(), getScreenHeight(), colorToRender);

    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) alpha = 255;
        if (alpha < 0) alpha = 0;
        return color & 16777215 | alpha << 24;
    }

}
