package de.keksuccino.drippyloadingscreen.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.*;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3694;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

@Mixin(class_425.class)
public class MixinLoadingOverlay {

    @Unique private static final Logger LOGGER_DRIPPY = LogManager.getLogger();

    @Unique private static boolean initializedDrippy = false;
    @Unique private static DrippyOverlayScreen drippyOverlayScreen = new DrippyOverlayScreen();

    @Unique private int lastScreenWidthDrippy = 0;
    @Unique private int lastScreenHeightDrippy = 0;
    @Unique private float cachedBackgroundOpacityDrippy = 1.0F;
    @Unique private float cachedElementOpacityDrippy = 1.0F;
    @Unique private double cachedOverlayScaleDrippy = 1.0D;

    @Shadow private float currentProgress;
    @Shadow private long fadeInStart;
    @Shadow @Final private boolean fadeIn;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void afterConstructDrippy(class_310 mc, class_4011 reload, Consumer<?> consumer, boolean b, CallbackInfo info) {

        if (!initializedDrippy) {
            //This makes text rendering work in the game loading screen
            LOGGER_DRIPPY.info("[DRIPPY LOADING SCREEN] Initializing fonts for text rendering..");
            this.loadFontsDrippy();
            initializedDrippy = true;
        }

        this.setNewOverlayScreenDrippy();
        this.lastScreenWidthDrippy = class_310.method_1551().method_22683().method_4486();
        this.lastScreenHeightDrippy = class_310.method_1551().method_22683().method_4502();
        this.initOverlayScreenDrippy(false);
        this.setBackgroundOpacityDrippy(1.0F);
        this.setElementsOpacityDrippy(1.0F);
        this.tickOverlayUpdateDrippy();

    }

    @Inject(method = "render", at = @At("RETURN"))
    private void afterRenderDrippy(class_4587 pose, int mouseX, int mouseY, float partial, CallbackInfo info) {

        GuiGraphics graphics = GuiGraphics.currentGraphics();

        if (this.shouldRenderVanillaDrippy()) return;

        MixinCache.cachedCurrentLoadingScreenProgress = this.currentProgress;
        this.tickOverlayUpdateDrippy();
        this.updateFadeInOpacityCacheDrippy();
        this.setBackgroundOpacityDrippy(this.cachedBackgroundOpacityDrippy);
        this.setElementsOpacityDrippy(DrippyLoadingScreen.getOptions().earlyFadeOutElements.getValue() ? this.cachedElementOpacityDrippy : this.cachedBackgroundOpacityDrippy);
        this.runMenuHandlerTaskDrippy(() -> {

            EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Pre(drippyOverlayScreen));
            drippyOverlayScreen.method_25393();
            EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Post(drippyOverlayScreen));

            this.restoreRenderDefaultsDrippy(graphics);

            //This is to render the overlay in its own scale while still rendering the actual current screen under it in the current screen's scale
            //It's important to calculate the fixed scale BEFORE updating the window GUI scale
            float renderScale = UIBase.calculateFixedScale((float)this.cachedOverlayScaleDrippy);
            double guiScale = class_310.method_1551().method_22683().method_4495();
            class_310.method_1551().method_22683().method_15997(this.cachedOverlayScaleDrippy);
            graphics.pose().method_22903();
            graphics.pose().method_22905(renderScale, renderScale, renderScale);

            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Pre(drippyOverlayScreen, graphics.pose(), mouseX, mouseY, partial));
            drippyOverlayScreen.method_25394(graphics.pose(), mouseX, mouseY, partial);
            this.restoreRenderDefaultsDrippy(graphics);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Post(drippyOverlayScreen, graphics.pose(), mouseX, mouseY, partial));

            //Reset scale after rendering
            graphics.pose().method_22905(1.0F, 1.0F, 1.0F);
            graphics.pose().method_22909();
            class_310.method_1551().method_22683().method_15997(guiScale);

            this.restoreRenderDefaultsDrippy(graphics);

        });

    }

    /**
     * @reason This replaces the outdated render() call with the new renderWithTooltip() call that FancyMenu hooks into for rendering events.
     */
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V"))
    private void wrap_Screen_render_in_render_Drippy(class_437 instance, class_4587 pose, int mouseX, int mouseY, float partial, Operation<Void> original) {
        if (!DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue()) return;
        RenderingUtils.setTooltipRenderingBlocked(true);
        // Keep depth test disabled during the whole screen rendering to make stuff from the screen not shine through the loading screen
        RenderSystem.disableDepthTest();
        RenderingUtils.setDepthTestLocked(true);
        Objects.requireNonNull(class_310.method_1551().field_1755).method_25394(pose, mouseX, mouseY, partial);
        RenderingUtils.setDepthTestLocked(false);
        RenderSystem.enableDepthTest();
        RenderingUtils.setTooltipRenderingBlocked(false);
    }

    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V"))
    private void beforeCloseOverlayDrippy(class_4587 pose, int mouseX, int mouseY, float partialTick, CallbackInfo info) {
        EventHandler.INSTANCE.postEvent(new CloseScreenEvent(drippyOverlayScreen, null));
    }

    @Inject(method = "drawProgressBar", at = @At("HEAD"), cancellable = true)
    private void cancelOriginalProgressBarRenderingDrippy(class_4587 pose, int minX, int minY, int maxX, int maxY, float opacity, CallbackInfo info) {
        if (!this.shouldRenderVanillaDrippy()) {
            info.cancel();
            this.cachedElementOpacityDrippy = DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue() ? opacity : 1.0F;
            RenderingUtils.resetShaderColor(GuiGraphics.currentGraphics());
        }
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LoadingOverlay;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"))
    private boolean cancelOriginalLogoRenderingDrippy(class_4587 poseStack, int i1, int i2, int i3, int i4, float v5, float v6, int i7, int i8, int i9, int i0) {
        return this.shouldRenderVanillaDrippy();
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LoadingOverlay;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"))
    private boolean cancelBackgroundRenderingDrippy(class_4587 poseStack, int minX, int minY, int maxX, int maxY, int color) {
        this.cachedBackgroundOpacityDrippy = DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue() ? Math.min(1.0F, Math.max(0.0F, (float)class_5253.class_5254.method_27762(color) / 255.0F)) : 1.0F;
        return this.shouldRenderVanillaDrippy();
    }

    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;_clear(IZ)V", shift = At.Shift.AFTER, remap = false))
    private void clearColorAfterBackgroundRenderingDrippy(class_4587 poseStack, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderingUtils.resetShaderColor(GuiGraphics.currentGraphics());
    }

    @Unique
    private void restoreRenderDefaultsDrippy(GuiGraphics graphics) {
        RenderingUtils.resetShaderColor(graphics);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
    }

    @Unique
    private boolean shouldRenderVanillaDrippy() {
        return (drippyOverlayScreen == null) || (this.getLayerDrippy() == null);
    }

    @Unique
    private void setBackgroundOpacityDrippy(float opacity) {
        if (this.getLayerDrippy() == null) return;
        this.getLayerDrippy().backgroundOpacity = opacity;
        drippyOverlayScreen.backgroundOpacity = opacity;
    }

    @Unique
    private void setElementsOpacityDrippy(float opacity) {
        if (opacity < 0.02F) {
            opacity = 0.02F;
        }
        boolean shouldBeVisible = opacity > 0.02F;
        if (this.getLayerDrippy() != null) {
            for (AbstractElement i : this.getLayerDrippy().allElements) {
                i.opacity = opacity;
                i.visible = shouldBeVisible;
            }
        }
    }

    @Unique
    @Nullable
    private ScreenCustomizationLayer getLayerDrippy() {
        if (drippyOverlayScreen == null) return null;
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen(drippyOverlayScreen);
        if (l != null) l.loadEarly = true;
        return l;
    }

    @SuppressWarnings("all")
    @Unique
    private void loadFontsDrippy() {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            try {
                Object m = ((IMixinSimplePreparableReloadListener)((IMixinFontManager)((IMixinMinecraft)class_310.method_1551()).getFontManagerDrippy()).getReloadListenerDrippy()).invokePrepareDrippy(class_310.method_1551().method_1478(), class_3694.field_16280);
                ((IMixinSimplePreparableReloadListener)((IMixinFontManager)((IMixinMinecraft)class_310.method_1551()).getFontManagerDrippy()).getReloadListenerDrippy()).invokeApplyDrippy(m, class_310.method_1551().method_1478(), class_3694.field_16280);
            } catch (Exception ex) {
                LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Failed to load fonts!", ex);
            }
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
    }

    @Unique
    private void tickOverlayUpdateDrippy() {
        try {
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            int screenHeight = class_310.method_1551().method_22683().method_4502();
            //Re-init overlay on window size change
            if ((screenWidth != this.lastScreenWidthDrippy) || (screenHeight != this.lastScreenHeightDrippy)) {
                this.initOverlayScreenDrippy(true);
            }
            this.lastScreenWidthDrippy = screenWidth;
            this.lastScreenHeightDrippy = screenHeight;
        } catch (Exception ex) {
            LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while updating overlay!", ex);
        }
    }

    @Unique
    private void updateFadeInOpacityCacheDrippy() {
        if (!DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue()) {
            return;
        }
        float fadeInOpacity = this.getFadeInOpacityDrippy();
        if (fadeInOpacity >= 0.0F && fadeInOpacity < 1.0F) {
            this.cachedBackgroundOpacityDrippy = fadeInOpacity;
            this.cachedElementOpacityDrippy = fadeInOpacity;
        }
    }

    @Unique
    private float getFadeInOpacityDrippy() {
        if (!this.fadeIn) {
            return -1.0F;
        }
        if (this.fadeInStart < 0L) {
            return -1.0F;
        }
        long now = class_156.method_658();
        float progress = (float)(now - this.fadeInStart) / (float)class_425.field_32248;
        return class_3532.method_15363(progress, 0.02F, 1.0F);
    }

    @Unique
    private void setNewOverlayScreenDrippy() {
        drippyOverlayScreen = new DrippyOverlayScreen();
        ScreenCustomizationLayerHandler.registerScreen(drippyOverlayScreen);
        this.getLayerDrippy(); //dummy call to let the method set loadEarly to true
    }

    @Unique
    private void initOverlayScreenDrippy(boolean resize) {
        this.runMenuHandlerTaskDrippy(() -> {
            try {
                double scale = class_310.method_1551().method_22683().method_4495();
                RenderingUtils.resetGuiScale();
                if (!resize) {
                    EventHandler.INSTANCE.postEvent(new OpenScreenEvent(drippyOverlayScreen));
                }
                drippyOverlayScreen.field_22789 = class_310.method_1551().method_22683().method_4486();
                drippyOverlayScreen.field_22790 = class_310.method_1551().method_22683().method_4502();
                EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                drippyOverlayScreen.method_25423(class_310.method_1551(), drippyOverlayScreen.field_22789, drippyOverlayScreen.field_22790);
                EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                if (!resize) {
                    EventHandler.INSTANCE.postEvent(new OpenScreenPostInitEvent(drippyOverlayScreen));
                }
                this.cachedOverlayScaleDrippy = class_310.method_1551().method_22683().method_4495();
                MixinCache.cachedLoadingOverlayScale = this.cachedOverlayScaleDrippy;
                class_310.method_1551().method_22683().method_15997(scale);
            } catch (Exception ex) {
                LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while initializing Drippy's overlay screen!", ex);
            }
        });
    }

    @Unique
    private void runMenuHandlerTaskDrippy(Runnable run) {
        try {
            boolean customizationEnabled = ScreenCustomization.isScreenCustomizationEnabled();
            ScreenCustomization.setScreenCustomizationEnabled(true);
            class_437 current = class_310.method_1551().field_1755;
            if (!(current instanceof DrippyOverlayScreen)) {
                class_310.method_1551().field_1755 = drippyOverlayScreen;
                run.run();
                class_310.method_1551().field_1755 = current;
            }
            ScreenCustomization.setScreenCustomizationEnabled(customizationEnabled);
        } catch (Exception ex) {
            LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while running menu handler task!", ex);
        }
    }

}
