package de.keksuccino.drippyloadingscreen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.platform.Services;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class DrippyEvents {

    private static final class_2960 EDIT_BUTTON_TEXTURE = class_2960.method_60655("drippyloadingscreen", "textures/edit_button.png");

    private ContextMenu drippyMenu;
    private ExtendedButton drippyButton;

    @NotNull
    public static Supplier<class_437> earlyLoadingEditorScreenSupplier = () -> null;

    @EventListener
    public void onInitOrResizeScreenCompleted(InitOrResizeScreenCompletedEvent e) {

        if ((e.getScreen() instanceof class_442) && CustomizationOverlay.isOverlayVisible(e.getScreen())) {

            this.drippyMenu = new ContextMenu()
                    .setForceDefaultTooltipStyle(true)
                    .setForceUIScale(true);

            this.drippyMenu.addClickableEntry("customize_loading_screen", class_2561.method_43471("drippyloadingscreen.settings.customize_loading_screen"), (menu, entry) -> {
                class_310.method_1551().method_1507(new DrippyOverlayScreen());
            }).setIcon(ContextMenu.IconFactory.getIcon("edit"));

            if (Services.PLATFORM.getPlatformName().equalsIgnoreCase("neoforge")) {

                this.drippyMenu.addClickableEntry("customize_early_loading_screen", class_2561.method_43471("drippyloadingscreen.settings.customize_early_loading_screen"), (menu, entry) -> {
                            if (DrippyLoadingScreen.isEarlyLoadingModulePresent()) {
                                class_437 s = earlyLoadingEditorScreenSupplier.get();
                                if (s != null) class_310.method_1551().method_1507(s);
                            } else {
                                class_437 current = class_310.method_1551().field_1755;
                                class_310.method_1551().method_1507(NotificationScreen.error(aBoolean -> {
                                    class_310.method_1551().method_1507(current);
                                }, LocalizationUtils.splitLocalizedLines("drippyloadingscreen.settings.customize_early_loading_screen.module_missing")));
                            }
                        }).setIcon(ContextMenu.IconFactory.getIcon("edit"))
                        .setTooltipSupplier((contextMenu, contextMenuEntry) -> Tooltip.of(class_2561.method_43471("drippyloadingscreen.settings.customize_early_loading_screen.desc")));

            }

            this.drippyMenu.addSeparatorEntry("separator_after_customize");

            this.drippyMenu.addValueCycleEntry("allow_universal_layouts",
                            CommonCycles.cycleEnabledDisabled("drippyloadingscreen.settings.allow_universal", DrippyLoadingScreen.getOptions().allowUniversalLayouts.getValue())
                                    .addCycleListener(value -> DrippyLoadingScreen.getOptions().allowUniversalLayouts.setValue(value.getAsBoolean())))
                    .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("drippyloadingscreen.settings.allow_universal.desc")))
                    .setIcon(ContextMenu.IconFactory.getIcon("layout"));

            this.drippyMenu.addValueCycleEntry("wait_for_textures_in_loading",
                            CommonCycles.cycleEnabledDisabled("drippyloadingscreen.settings.wait_for_textures_in_loading", DrippyLoadingScreen.getOptions().waitForTexturesInLoading.getValue())
                                    .addCycleListener(value -> DrippyLoadingScreen.getOptions().waitForTexturesInLoading.setValue(value.getAsBoolean())))
                    .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("drippyloadingscreen.settings.wait_for_textures_in_loading.desc")))
                    .setIcon(ContextMenu.IconFactory.getIcon("timer"));

            this.drippyMenu.addValueCycleEntry("early_fade_out_elements",
                            CommonCycles.cycleEnabledDisabled("drippyloadingscreen.settings.early_fade_out_elements", DrippyLoadingScreen.getOptions().earlyFadeOutElements.getValue())
                                    .addCycleListener(value -> DrippyLoadingScreen.getOptions().earlyFadeOutElements.setValue(value.getAsBoolean())))
                    .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("drippyloadingscreen.settings.early_fade_out_elements.desc")));

            this.drippyMenu.addValueCycleEntry("fade_out_loading_screen",
                            CommonCycles.cycleEnabledDisabled("drippyloadingscreen.settings.fade_out_loading_screen", DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue())
                                    .addCycleListener(value -> DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.setValue(value.getAsBoolean())))
                    .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("drippyloadingscreen.settings.fade_out_loading_screen.desc")));

            //------------------------------

            ExtendedButton editButton = new ExtendedButton(-30, 40, 80, 40, class_2561.method_43473(), (button) -> {
                drippyMenu.openMenuAt(10, 80 - 10);
            }) {

                @Override
                public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

                    this.field_22765 = 1.0F;

                    var m = CustomizationOverlay.getCurrentMenuBarInstance();
                    if ((m == null) || (!m.isUserNavigatingInMenuBar() && !drippyMenu.isUserNavigatingInMenu())) {
                        TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("drippyloadingscreen.edit_loading_screen.desc")).setDefaultStyle().setScale(UIBase.getUIScale()), () -> this.field_22762, false, true);
                    }
                    if (this.method_25367() || drippyMenu.isOpen()) {
                        this.method_46421(-20);
                    } else {
                        this.method_46421(-30);
                    }
                    super.method_25394(graphics, mouseX, mouseY, partial);
                    RenderSystem.enableBlend();
                    RenderingUtils.resetShaderColor(graphics);
                    graphics.method_25290(EDIT_BUTTON_TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
                    RenderingUtils.resetShaderColor(graphics);

                    drippyMenu.method_25394(graphics, mouseX, mouseY, partial);

                }

                @Override
                protected void renderBackground(@NotNull class_332 graphics) {
                    boolean b = this.field_22762;
                    if (drippyMenu.isOpen()) this.field_22762 = true;
                    super.renderBackground(graphics);
                    this.field_22762 = b;
                }

                @Override
                public boolean method_25402(double $$0, double $$1, int $$2) {
                    if (drippyMenu.isOpen() && !drippyMenu.isUserNavigatingInMenu() && !this.method_49606()) {
                        drippyMenu.closeMenu();
                        this.method_25365(false);
                    }
                    return super.method_25402($$0, $$1, $$2);
                }

            };
            UIBase.applyDefaultWidgetSkinTo(editButton);

            // 2 because MenuBar and DebugOverlay need to be at pos 0 and 1
            e.getWidgets().add(2, editButton);
            this.drippyButton = editButton;
            e.getWidgets().add(2, this.drippyMenu);

        }

    }

    @EventListener(priority = 0) //FM is -1
    public void onScreenRenderPost(RenderScreenEvent.Post e) {

        if ((e.getScreen() instanceof class_442) && CustomizationOverlay.isOverlayVisible(e.getScreen())) {
            if (this.drippyButton != null) {
                this.drippyButton.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
        }

    }

}
