package de.keksuccino.drippyloadingscreen.customization;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.function.IntSupplier;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_5253;

public class DrippyOverlayScreen extends class_437 {

    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 MOJANG_STUDIOS_LOGO_LOCATION = class_2960.method_60654("textures/gui/title/mojangstudios.png");

    public float backgroundOpacity = 1.0F;

    public DrippyOverlayScreen() {
        super(class_2561.method_43473());
        MixinCache.cachedCurrentLoadingScreenProgress = 0.5F;
        this.forceEnableCustomizations();
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            LOGGER.info("[DRIPPY LOADING SCREEN] Force-enabling customizations for DrippyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled(this, true);
        }
    }

    @Override
    protected void method_25426() {

        this.method_37063(buildLogoWidget());

        this.method_37063(buildProgressBarWidget());

    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    @Override
    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(this);
        boolean shouldRenderDefaultBackground = (layer == null) || layer.layoutBase.menuBackgrounds.isEmpty();
        IntSupplier supplier = IMixinLoadingOverlay.getBrandBackgroundDrippy();
        int color = (supplier != null) ? supplier.getAsInt() : 0;
        if (shouldRenderDefaultBackground) {
            RenderingUtils.resetShaderColor(graphics);
            graphics.method_51739(class_1921.method_51785(), 0, 0, this.field_22789, this.field_22790, replaceAlpha(color, (int)(this.backgroundOpacity * 255.0F)));
            RenderingUtils.resetShaderColor(graphics);
        }
        EventHandler.INSTANCE.postEvent(new RenderedScreenBackgroundEvent(this, graphics, mouseX, mouseY, partial));
    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) alpha = 255;
        if (alpha < 0) alpha = 0;
        return color & 16777215 | alpha << 24;
    }

    public static RendererWidget buildLogoWidget() {

        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int centerX = (int) ((double) screenWidth * 0.5D);
        int centerY = (int) ((double) screenHeight * 0.5D);

        double logoHeight = Math.min((double) mc.method_22683().method_4486() * 0.75D, mc.method_22683().method_4502()) * 0.25D;
        int logoHeightHalf = (int) (logoHeight * 0.5D);
        double logoWidth = logoHeight * 4.0D;
        int logoWidthHalf = (int) (logoWidth * 0.5D);
        int logoPosX = centerX - logoWidthHalf;
        int logoPosY = centerY - logoHeightHalf;

        return new RendererWidget(logoPosX, logoPosY, logoWidthHalf * 2, logoHeightHalf * 2,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask(false);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc(770, 1);
                    graphics.method_51422(1.0F, 1.0F, 1.0F, ((IMixinAbstractWidget)widget).getAlphaFancyMenu());
                    graphics.method_25293(MOJANG_STUDIOS_LOGO_LOCATION, x, y, width / 2, height, -0.0625F, 0.0F, 120, 60, 120, 120);
                    graphics.method_25293(MOJANG_STUDIOS_LOGO_LOCATION, x + (width / 2), y, (width / 2), height, 0.0625F, 60.0F, 120, 60, 120, 120);
                    RenderingUtils.resetShaderColor(graphics);
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.depthMask(true);
                    RenderSystem.enableDepthTest();
                }
        ).setWidgetIdentifierFancyMenu("mojang_logo");

    }

    public static RendererWidget buildProgressBarWidget() {

        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();

        double someDouble1 = Math.min((double)screenWidth * 0.75D, screenHeight) * 0.25D;
        double someDouble2 = someDouble1 * 4.0D;
        int someInt1 = (int)(someDouble2 * 0.5D);
        int someInt2 = (int)((double)screenHeight * 0.8325D);
        int barPosX = screenWidth / 2 - someInt1;
        int barPosY = someInt2 - 5;
        int barWidth = someInt1 * 2;
        int barHeight = 10;

        return new RendererWidget(barPosX, barPosY, barWidth, barHeight,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
                    float currentProgress = 0.5F;
                    if (class_310.method_1551().method_18506() instanceof class_425) {
                        currentProgress = ((IMixinLoadingOverlay)class_310.method_1551().method_18506()).getCurrentProgressDrippy();
                    }
                    RenderingUtils.resetShaderColor(graphics);
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableBlend();
                    RenderSystem.depthMask(true);
                    RenderSystem.enableDepthTest();
                    drawProgressBar(graphics, x, y, x + width, y + height, ((IMixinAbstractWidget)widget).getAlphaFancyMenu(), currentProgress);
                    RenderingUtils.resetShaderColor(graphics);
                }
        ).setWidgetIdentifierFancyMenu("progress_bar");

    }

    private static void drawProgressBar(class_332 graphics, int xMin, int yMin, int xMax, int yMax, float opacity, float currentProgress) {
        int i = class_3532.method_15386((float)(xMax - xMin - 2) * currentProgress);
        int j = Math.round(opacity * 255.0F);
        int k = class_5253.class_5254.method_27764(j, 255, 255, 255);
        graphics.method_25294(xMin + 2, yMin + 2, xMin + i, yMax - 2, k);
        graphics.method_25294(xMin + 1, yMin, xMax - 1, yMin + 1, k);
        graphics.method_25294(xMin + 1, yMax, xMax - 1, yMax - 1, k);
        graphics.method_25294(xMin, yMin, xMin + 1, yMax, k);
        graphics.method_25294(xMax, yMin, xMax - 1, yMax, k);
    }

}
