/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.dynres;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.dynres.Cfg;
import io.gitlab.jfronny.libjf.web.api.v1.PathSegment;
import io.gitlab.jfronny.libjf.web.api.v1.WebEntrypoint;
import io.gitlab.jfronny.libjf.web.api.v1.WebServer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class DynRes
implements WebEntrypoint {
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"DynRes");
    public static Path packFile;
    public static String packUrl;

    public void register(WebServer api) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && packFile != null) {
            try {
                packUrl = api.registerFile(PathSegment.of((String)"resources.zip"), packFile, true);
                LOGGER.info("Initialized DynRes at {0}", new Object[]{packUrl});
            }
            catch (IOException e) {
                LOGGER.error("Could not register DynRes resource pack", (Throwable)e);
            }
        }
    }

    static {
        packUrl = "";
        packFile = FabricLoader.getInstance().getGameDir().resolve(Cfg.resourcesFile);
        if (!Files.exists(packFile, new LinkOption[0])) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                LOGGER.error("The resource file specified in your config could not be found. YOU MUST SPECIFY A RESOURCE PACK FOR IT TO BE SERVED!", new Object[0]);
            }
            packFile = null;
        }
    }
}

