/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.dynres.mixin;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.dynres.Cfg;
import io.gitlab.jfronny.dynres.DynRes;
import io.gitlab.jfronny.dynres.IServerResourcePackProperties;
import io.gitlab.jfronny.libjf.web.api.v1.WebServer;
import io.gitlab.jfronny.libjf.web.impl.util.WebPaths;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class_7460.class})
public class ServerResourcePackPropertiesMixin
implements IServerResourcePackProperties {
    @Unique
    private final LazySupplier<String> urlSupplier = new LazySupplier(() -> WebPaths.concat((String)WebServer.getInstance().getServerRoot(), (String)"resources.zip"));
    @Unique
    private final LazySupplier<UUID> idSupplier = ServerResourcePackPropertiesMixin.map(this.urlSupplier, s -> UUID.nameUUIDFromBytes(((String)s.get()).getBytes(StandardCharsets.UTF_8)));
    @Unique
    private String hash;
    @Unique
    private FileTime hashTimestamp;

    @Unique
    private static <T, R> LazySupplier<R> map(LazySupplier<T> supplier, Function<LazySupplier<T>, R> function) {
        return supplier.andThen(function);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(UUID uUID, String string, String string2, boolean bl, class_2561 text, CallbackInfo ci) {
        if (Cfg.hashResources) {
            this.dynres$rehash();
        }
    }

    @Inject(method={"id"}, at={@At(value="TAIL")}, cancellable=true)
    public void id(CallbackInfoReturnable<UUID> cir) {
        cir.setReturnValue((Object)((UUID)this.idSupplier.get()));
    }

    @Inject(method={"url"}, at={@At(value="TAIL")}, cancellable=true)
    public void url(CallbackInfoReturnable<String> cir) {
        cir.setReturnValue((Object)((String)this.urlSupplier.get()));
    }

    @Inject(method={"hash"}, at={@At(value="TAIL")}, cancellable=true)
    public void hash(CallbackInfoReturnable<String> cir) {
        if (!Cfg.hashResources) {
            return;
        }
        try {
            if (!Objects.equals(this.hashTimestamp, Files.getLastModifiedTime(DynRes.packFile, new LinkOption[0]))) {
                this.dynres$rehash();
            }
        }
        catch (IOException e) {
            DynRes.LOGGER.error("Failed to get last modified time for hash resources", (Throwable)e);
        }
        cir.setReturnValue((Object)this.hash);
    }

    @Override
    public void dynres$rehash() {
        try {
            this.hashTimestamp = Files.getLastModifiedTime(DynRes.packFile, new LinkOption[0]);
            StringBuilder result = new StringBuilder();
            for (byte b : MessageDigest.getInstance("SHA-1").digest(Files.readAllBytes(DynRes.packFile))) {
                result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            this.hash = result.toString();
            DynRes.LOGGER.info("Set hash to {0}", new Object[]{this.hash});
        }
        catch (IOException | NoSuchAlgorithmException e) {
            DynRes.LOGGER.error("Failed to get hash, continuing with empty", (Throwable)e);
            this.hash = "";
        }
    }
}

