/*
 * Decompiled with CFR 0.152.
 */
package com.letruxux.more_curios_slots;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class ExtraSlotItem
extends Item {
    private final String SlotNameString;

    public ExtraSlotItem(Item.Properties properties, String slot) {
        super(properties.rarity(Rarity.RARE));
        this.SlotNameString = slot;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Adds +1 %s slot to your player. Permanent!".formatted(this.SlotNameString)).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack itemStack = player.getItemInHand(hand);
            Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventory.isPresent()) {
                player.displayClientMessage((Component)Component.literal((String)String.format("You just unlocked +1 %s slot!", this.SlotNameString)), true);
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, 1));
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, player.getSoundSource(), 1.0f, 1.0f);
                itemStack.shrink(1);
                curiosInventory.ifPresent(inventory -> inventory.addPermanentSlotModifier(this.SlotNameString, ResourceLocation.fromNamespaceAndPath((String)"more_curios_slots", (String)UUID.randomUUID().toString()), 1.0, AttributeModifier.Operation.ADD_VALUE));
            } else {
                player.displayClientMessage((Component)Component.literal((String)"Curios inventory not found, are you sure you have any curios-supported mods?"), true);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PILLAGER_AMBIENT, player.getSoundSource(), 1.0f, 1.0f);
            }
        }
        return super.use(level, player, hand);
    }
}

