/*
 * Decompiled with CFR 0.152.
 */
package com.letruxux.more_curios_slots;

import com.letruxux.more_curios_slots.Utils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public class ExtraSlotItem
extends Item {
    private final String SlotNameString;

    public ExtraSlotItem(Item.Properties properties, String slot) {
        super(properties.m_41497_(Rarity.RARE));
        this.SlotNameString = slot;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        components.add((Component)Component.m_237113_((String)"Adds +1 %s slot to your player. Permanent!".formatted(this.SlotNameString)).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            ItemStack itemStack = player.m_21120_(hand);
            LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventory.isPresent() && CuriosApi.getSlots((Level)level).containsKey(this.SlotNameString)) {
                player.m_5661_((Component)Component.m_237113_((String)String.format("You just unlocked +1 %s slot!", this.SlotNameString)), true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 1));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, player.m_5720_(), 1.0f, 1.0f);
                itemStack.m_41774_(1);
                curiosInventory.ifPresent(inventory -> inventory.addPermanentSlotModifier(this.SlotNameString, UUID.randomUUID(), String.format("Extra %s Slot", Utils.toTitleCase(this.SlotNameString)), 1.0, AttributeModifier.Operation.ADDITION));
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"Curios inventory not found, are you sure you have any curios-supported mods?"), true);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12307_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
        return super.m_7203_(level, player, hand);
    }
}

