/*
 * Decompiled with CFR 0.152.
 */
package com.letruxux.more_curios_slots;

import com.letruxux.more_curios_slots.Utils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public class ExtraSlotItem
extends Item {
    private final String SlotNameString;

    private boolean isSlotInCurios() {
        TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation("curios", this.SlotNameString));
        List<Item> itemsInTag = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(tag)).toList();
        return !itemsInTag.isEmpty();
    }

    public ExtraSlotItem(Item.Properties properties, String slot) {
        super(properties.m_41497_(Rarity.RARE));
        this.SlotNameString = slot;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        boolean slotExists;
        components.add((Component)Component.m_237113_((String)"Adds +1 %s slot to your player. Permanent!".formatted(this.SlotNameString)).m_130940_(ChatFormatting.GRAY));
        if (level != null && level.m_5776_() && !(slotExists = this.isSlotInCurios())) {
            components.add((Component)Component.m_237113_((String)"This slot is not available in your modpack! It will be useless.").m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.isSlotInCurios()) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)String.format("There is no mod in this modpack that supports the %s slot. You can't unlock this.", this.SlotNameString)).m_130940_(ChatFormatting.RED), true);
            } else {
                player.m_216990_(SoundEvents.f_12506_);
            }
            return super.m_7203_(level, player, hand);
        }
        if (!level.f_46443_) {
            player.m_5661_((Component)Component.m_237113_((String)String.format("You just unlocked +1 %s slot!", this.SlotNameString)), true);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 1));
        } else {
            player.m_216990_(SoundEvents.f_11871_);
        }
        itemStack.m_41774_(1);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> inventory.addPermanentSlotModifier(this.SlotNameString, UUID.randomUUID(), String.format("Extra %s Slot", Utils.toTitleCase(this.SlotNameString)), 1.0, AttributeModifier.Operation.ADDITION));
        return super.m_7203_(level, player, hand);
    }
}

