/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.inventorytotem;

import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InventoryTotem
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        ItemStack totem;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getFinalDamage() >= player.getHealth() && (totem = this.findTotem(player)) != null) {
            totem.setAmount(totem.getAmount() - 1);
            player.setHealth(1.0);
            player.setFireTicks(0);
            player.setFallDistance(0.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0));
            player.getWorld().spawnParticle(Particle.TOTEM, player.getLocation(), 30, 0.5, 1.0, 0.5, 0.1);
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
            event.setCancelled(true);
        }
    }

    private ItemStack findTotem(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.TOTEM_OF_UNDYING) continue;
            return item;
        }
        return null;
    }
}

