/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.client.core;

import com.trinarybrain.magianaturalis.api.ISpectacles;
import com.trinarybrain.magianaturalis.client.util.RenderUtil;
import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.item.artifact.ItemGogglesDark;
import com.trinarybrain.magianaturalis.common.item.focus.ItemFocusBuild;
import com.trinarybrain.magianaturalis.common.tile.TileArcaneChest;
import com.trinarybrain.magianaturalis.common.util.FocusBuildHelper;
import com.trinarybrain.magianaturalis.common.util.Platform;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileNodeEnergized;
import thaumcraft.common.tiles.TileOwned;

@SideOnly(value=Side.CLIENT)
public class EventHandlerRender {
    private static final ResourceLocation SILKTOUCH_TEXTURE = new ResourceLocation("thaumcraft", "textures/foci/silktouch.png");
    private static final ResourceLocation HUD_FRAME_TEXTURE = MagiaNaturalis.rl("textures/misc/frame-gold.png");
    private static final ResourceLocation GLOWING_EYES_TEXTURE = MagiaNaturalis.rl("textures/models/glowingEyes.png");
    private static final ModelBiped OVERLAY_MODEL = new ModelBiped();
    public Minecraft mc = Minecraft.func_71410_x();
    FontRenderer fontRenderer;
    RenderItem itemRender;
    ItemStack lastItem;
    int lastCount;

    public EventHandlerRender() {
        this.fontRenderer = this.mc.field_71466_p;
        this.itemRender = new RenderItem();
        this.lastItem = null;
        this.lastCount = 0;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerRender());
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HELMET && Minecraft.func_71382_s() && !this.mc.func_147113_T() && this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74330_P && this.mc.field_71451_h != null && this.mc.field_71451_h instanceof EntityPlayer) {
            ItemWandCasting wand;
            ItemFocusBasic focus;
            EntityPlayer player = (EntityPlayer)this.mc.field_71451_h;
            ItemStack stack = player.field_71071_by.func_70440_f(3);
            if (stack != null && stack.func_77973_b() instanceof ISpectacles && ((ISpectacles)stack.func_77973_b()).drawSpectacleHUD(stack, (EntityLivingBase)player)) {
                this.renderSpectaclesHUD(this.mc, player);
            }
            if ((stack = player.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemWandCasting && (focus = (wand = (ItemWandCasting)stack.func_77973_b()).getFocus(stack)) instanceof ItemFocusBuild) {
                ItemStack focusStack = wand.getFocusItem(stack);
                this.renderBuildFocusHUD(focusStack, player);
            }
        }
    }

    @SubscribeEvent
    public void renderPlayerSpecial(RenderPlayerEvent.Specials.Pre event) {
        ModelBiped model = event.renderer.field_77109_a;
        ItemStack itemstack = event.entityPlayer.field_71071_by.func_70440_f(3);
        if (event.renderHelmet && itemstack != null && itemstack.func_77973_b() instanceof ItemGogglesDark) {
            GL11.glPushMatrix();
            float f6 = 0.0625f;
            model.field_78116_c.func_78794_c(f6);
            this.mc.field_71446_o.func_110577_a(GLOWING_EYES_TEXTURE);
            GL11.glTranslatef((float)0.0f, (float)f6, (float)-0.01f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glDepthMask((!event.entityPlayer.func_82150_aj() ? 1 : 0) != 0);
            int c0 = 61680;
            int j = c0 % 65536;
            int k = c0 / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            EventHandlerRender.OVERLAY_MODEL.field_78116_c.func_78785_a(f6);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    protected void renderBuildFocusHUD(ItemStack focusStack, EntityPlayer player) {
        GL11.glClear((int)256);
        FocusBuildHelper.Meta meta = FocusBuildHelper.getMeta(focusStack);
        Block pblock = null;
        int pbdata = 0;
        Item item = null;
        ItemStack pickedBlock = null;
        if (meta == FocusBuildHelper.Meta.UNIFORM) {
            if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                pblock = player.field_70170_p.func_147439_a(this.mc.field_71476_x.field_72311_b, this.mc.field_71476_x.field_72312_c, this.mc.field_71476_x.field_72309_d);
                pbdata = player.field_70170_p.func_72805_g(this.mc.field_71476_x.field_72311_b, this.mc.field_71476_x.field_72312_c, this.mc.field_71476_x.field_72309_d);
                item = Item.func_150898_a((Block)pblock);
            }
            if (item != null) {
                if (pblock == Blocks.field_150398_cm) {
                    pbdata = pblock.func_149643_k(player.field_70170_p, this.mc.field_71476_x.field_72311_b, this.mc.field_71476_x.field_72312_c, this.mc.field_71476_x.field_72309_d);
                }
                pickedBlock = new ItemStack(item, 1, pbdata);
            }
            if (pickedBlock == null && pblock != null) {
                pickedBlock = pblock == Blocks.field_150439_ay ? new ItemStack(Blocks.field_150450_ax) : pblock.getPickBlock(this.mc.field_71476_x, player.field_70170_p, this.mc.field_71476_x.field_72311_b, this.mc.field_71476_x.field_72312_c, this.mc.field_71476_x.field_72309_d);
            }
        } else {
            int[] i = FocusBuildHelper.getPickedBlock(focusStack);
            pblock = Block.func_149729_e((int)i[0]);
            pbdata = i[1];
            if (pblock != Blocks.field_150350_a && pblock != null) {
                item = Item.func_150898_a((Block)pblock);
                pickedBlock = new ItemStack(item, 1, pbdata);
            }
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)45.0f, (float)40.0f, (float)0.0f);
        RenderUtil.drawTextureQuad(HUD_FRAME_TEXTURE, 32.0f, 32.0f);
        if (pickedBlock == null && meta == FocusBuildHelper.Meta.UNIFORM) {
            GL11.glTranslatef((float)1.5f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            RenderUtil.drawTextureQuad(SILKTOUCH_TEXTURE, 30.0f, 30.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        if (pickedBlock != null) {
            int amount = this.lastCount;
            if (player.field_71071_by.field_70459_e || !pickedBlock.func_77969_a(this.lastItem)) {
                amount = 0;
                for (ItemStack is : player.field_71071_by.field_70462_a) {
                    if (is == null || !is.func_77969_a(pickedBlock)) continue;
                    amount += is.field_77994_a;
                }
                this.lastItem = pickedBlock;
                player.field_71071_by.field_70459_e = false;
            }
            this.lastCount = amount;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)49.0f, (float)44.0f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            if (this.itemRender != null && this.fontRenderer != null) {
                RenderUtil.drawItemStack(this.itemRender, this.fontRenderer, pickedBlock, 0, 0);
            }
            GL11.glEnable((int)3042);
            GL11.glPushMatrix();
            String am = "" + amount;
            int sw = this.fontRenderer.func_78256_a(am);
            GL11.glTranslatef((float)0.0f, (float)(-this.fontRenderer.field_78288_b), (float)500.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a != 0 && b != 0 || a == 0 && b == 0) continue;
                    this.mc.field_71466_p.func_78276_b(am, a + 16 - sw, b + 24, 0);
                }
            }
            this.mc.field_71466_p.func_78276_b(am, 16 - sw, 24, 0xFFFFFF);
            if (meta == FocusBuildHelper.Meta.UNIFORM) {
                GL11.glPushMatrix();
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                GL11.glTranslatef((float)15.0f, (float)15.0f, (float)0.0f);
                RenderUtil.drawTextureQuad(SILKTOUCH_TEXTURE, 16.0f, 16.0f);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        } else if (meta != FocusBuildHelper.Meta.UNIFORM) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)49.0f, (float)44.0f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glPushMatrix();
            String amount = "?";
            int width = this.fontRenderer.func_78256_a(amount);
            GL11.glTranslatef((float)0.0f, (float)(-this.fontRenderer.field_78288_b), (float)500.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a != 0 && b != 0 || a == 0 && b == 0) continue;
                    this.mc.field_71466_p.func_78276_b(amount, a + 16 - width, b + 24, 0);
                }
            }
            this.mc.field_71466_p.func_78276_b(amount, 16 - width, 24, 0xFFFFFF);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    protected void renderSpectaclesHUD(Minecraft mc, EntityPlayer player) {
        boolean meterEquiped = false;
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == ConfigItems.itemThaumometer) {
            meterEquiped = true;
        }
        if (mc.field_71474_y.field_74320_O == 0 && mc.field_71462_r == null && !meterEquiped) {
            TileEntity tile = null;
            MovingObjectPosition mop = mc.field_71476_x;
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                tile = player.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            }
            if (tile != null) {
                ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                int w = scaledresolution.func_78326_a();
                int h = scaledresolution.func_78328_b();
                if (tile instanceof INode) {
                    INode node = (INode)tile;
                    String meta = Platform.translate("nodetype." + node.getNodeType() + ".name");
                    if (node.getNodeModifier() != null) {
                        meta = meta + ", " + Platform.translate("nodemod." + node.getNodeModifier() + ".name");
                    }
                    String name = Platform.translate("tile.blockAiry.0.name");
                    FontRenderer fontRenderer = mc.field_71466_p;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(name, -fontRenderer.func_78256_a(name) / 2, 25, 15751100);
                    fontRenderer.func_78261_a(meta, -fontRenderer.func_78256_a(meta) / 2, 35, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof TileNodeEnergized) {
                    TileNodeEnergized nodeEnergized = (TileNodeEnergized)tile;
                    String meta = Platform.translate("nodetype." + nodeEnergized.getNodeType() + ".name");
                    if (nodeEnergized.getNodeModifier() != null) {
                        meta = meta + ", " + Platform.translate("nodemod." + nodeEnergized.getNodeModifier() + ".name");
                    }
                    String name = Platform.translate("tile.blockAiry.5.name");
                    FontRenderer fontRenderer = mc.field_71466_p;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(name, -fontRenderer.func_78256_a(name) / 2, 25, 15751100);
                    fontRenderer.func_78261_a(meta, -fontRenderer.func_78256_a(meta) / 2, 35, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof TileOwned) {
                    TileOwned owned = (TileOwned)tile;
                    String owner = EnumChatFormatting.DARK_PURPLE + "Owner" + EnumChatFormatting.RESET + " " + owned.owner;
                    FontRenderer fontRenderer = mc.field_71466_p;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(owner, -(fontRenderer.func_78256_a(owner) - 4) / 2, 25, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof TileArcaneChest) {
                    TileArcaneChest chest = (TileArcaneChest)tile;
                    String name = EnumChatFormatting.DARK_PURPLE + "Owner" + EnumChatFormatting.RESET + " " + chest.getOwnerName();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    this.fontRenderer.func_78261_a(name, -(this.fontRenderer.func_78256_a(name) - 4) / 2, 25, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
            }
        }
    }
}

