/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.block;

import com.trinarybrain.magianaturalis.client.util.RenderUtil;
import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.tile.TileArcaneChest;
import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.access.UserAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.utils.InventoryUtils;

public class BlockArcaneChest
extends BlockContainer {
    private byte CacheChestType;

    public BlockArcaneChest() {
        super(Material.field_151575_d);
        this.func_149752_b(999.0f);
        this.func_149711_c(8.0f);
        this.func_149672_a(field_149766_f);
    }

    public static boolean setChestType(ItemStack stack, byte type) {
        if (stack != null && type > 0) {
            if (type > 2) {
                return false;
            }
            NBTUtil.openNbtData(stack).func_74774_a("chestType", type);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack(item, 1, 1);
        BlockArcaneChest.setChestType(stack, (byte)1);
        list.add(stack);
        stack = new ItemStack(item, 1, 2);
        BlockArcaneChest.setChestType(stack, (byte)2);
        list.add(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("thaumcraft:woodplain");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderUtil.RenderID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (chest != null && player != null) {
            if (chest.owner.equals(player.func_146103_bH().getId())) {
                return false;
            }
            if (chest.accessList != null && chest.accessList.size() > 0) {
                for (UserAccess user : chest.accessList) {
                    if (!user.getUUID().equals(player.func_146103_bH().getId())) continue;
                    return user.getAccessLevel() > 1;
                }
            }
        }
        float f = (float)target.field_72307_f.field_72450_a - (float)target.field_72311_b;
        float f1 = (float)target.field_72307_f.field_72448_b - (float)target.field_72312_c;
        float f2 = (float)target.field_72307_f.field_72449_c - (float)target.field_72309_d;
        MagiaNaturalis.proxyTC4.blockWard(world, (double)target.field_72311_b, (double)target.field_72312_c, (double)target.field_72309_d, ForgeDirection.getOrientation((int)target.field_72310_e), f, f1, f2);
        return true;
    }

    public byte getChestType(ItemStack stack) {
        if (stack != null) {
            return NBTUtil.openNbtData(stack).func_74771_c("chestType");
        }
        return 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileArcaneChest();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int meta = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        world.func_72921_c(x, y, z, meta, 3);
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(x, y, z);
        if (chest != null) {
            EntityPlayer player = (EntityPlayer)entity;
            chest.owner = player.func_110124_au();
            chest.setChestType(this.getChestType(stack));
            ItemStack[] items = NBTUtil.loadInventoryFromNBT(stack, chest.func_70302_i_());
            if (items != null && items.length == chest.func_70302_i_()) {
                chest.setInvetory(items);
            } else if (chest.getChestType() == 2) {
                chest.setInvetory(new ItemStack[77]);
            }
            ArrayList<UserAccess> users = NBTUtil.loadUserAccessFromNBT(stack);
            if (!users.isEmpty()) {
                chest.accessList = users;
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float f0, float f1, float f3) {
        if (Platform.isClient()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileArcaneChest) {
            TileArcaneChest chest = (TileArcaneChest)tile;
            boolean hasAccess = false;
            if (player.field_71075_bZ.field_75098_d || player.func_146103_bH().getId().equals(chest.owner)) {
                hasAccess = true;
            } else if (chest.accessList != null && chest.accessList.size() > 0) {
                for (UserAccess user : chest.accessList) {
                    if (!user.getUUID().equals(player.func_146103_bH().getId())) continue;
                    hasAccess = user.hasAccess();
                    break;
                }
            }
            if (hasAccess) {
                player.openGui((Object)MagiaNaturalis.instance, 2, world, x, y, z);
            } else {
                world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:doorfail", 0.66f, 1.0f);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + Platform.translate("chat.magianaturalis.chest.access.denied")));
            }
            return true;
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack curStack;
        TileEntity tile;
        if (Platform.isServer() && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileArcaneChest && (curStack = player.func_71045_bC()) != null && curStack.func_77973_b() == ConfigItems.itemKey) {
            String loc;
            TileArcaneChest chest = (TileArcaneChest)tile;
            int isKeyAdmin = 0;
            if (player.field_71075_bZ.field_75098_d || player.func_146103_bH().getId().equals(chest.owner)) {
                isKeyAdmin = 2;
            } else if (chest.accessList != null && chest.accessList.size() > 0) {
                for (UserAccess user : chest.accessList) {
                    if (!user.getUUID().equals(player.func_146103_bH().getId())) continue;
                    if (user.getAccessLevel() <= 0) break;
                    isKeyAdmin = 1;
                    break;
                }
            }
            if (curStack.func_77942_o() && curStack.field_77990_d.func_74764_b("location")) {
                loc = x + "," + y + "," + z;
                if (!loc.equals(curStack.field_77990_d.func_74779_i("location"))) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + Platform.translate("tc.key7")));
                } else if (loc.equals(curStack.field_77990_d.func_74779_i("location"))) {
                    if (isKeyAdmin > 0) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + Platform.translate("tc.key8")));
                    } else if (isKeyAdmin == 0) {
                        chest.accessList.add(new UserAccess(player.func_146103_bH().getId(), (byte)curStack.func_77960_j()));
                        world.func_147471_g(x, y, z);
                        if (!player.field_71075_bZ.field_75098_d && --curStack.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                        player.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + Platform.translate("chat.magianaturalis.key.access.chest")));
                        world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:key", 1.0f, 0.9f);
                    }
                }
            } else if (!curStack.func_77942_o()) {
                if (isKeyAdmin > 0) {
                    loc = x + "," + y + "," + z;
                    ItemStack stack = new ItemStack(ConfigItems.itemKey, 1, curStack.func_77960_j());
                    stack.func_77983_a("location", (NBTBase)new NBTTagString(loc));
                    stack.func_77983_a("type", (NBTBase)new NBTTagByte(-1));
                    if (!player.field_71075_bZ.field_75098_d && --curStack.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    if (!player.field_71071_by.func_70441_a(stack)) {
                        world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
                    }
                    world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:key", 1.0f, 0.9f);
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + Platform.translate("chat.magianaturalis.chest.access.denied")));
                    world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:doorfail", 0.66f, 1.0f);
                }
            }
        }
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(x, y, z);
        if (chest != null && player != null && player instanceof EntityPlayer) {
            if (chest.owner.equals(player.func_146103_bH().getId())) {
                return ForgeHooks.blockStrength((Block)this, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
            }
            if (chest.accessList != null && chest.accessList.size() > 0) {
                for (UserAccess user : chest.accessList) {
                    if (!user.getUUID().equals(player.func_146103_bH().getId())) continue;
                    if (user.getAccessLevel() <= 1) break;
                    return ForgeHooks.blockStrength((Block)this, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
                }
            }
        }
        return 0.0f;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(x, y, z);
        if (chest != null && entity != null && entity instanceof EntityPlayer) {
            if (chest.owner.equals(entity.func_110124_au())) {
                return true;
            }
            if (chest.accessList != null && chest.accessList.size() > 0) {
                for (UserAccess user : chest.accessList) {
                    if (!user.getUUID().equals(entity.func_110124_au())) continue;
                    return user.getAccessLevel() > 1;
                }
            }
        }
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(x, y, z);
        if (chest != null) {
            this.CacheChestType = (byte)chest.getChestType();
        }
        InventoryUtils.dropItems((World)world, (int)x, (int)y, (int)z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.CacheChestType != -1) {
            ItemStack stack = new ItemStack((Block)this, 1, (int)this.CacheChestType);
            BlockArcaneChest.setChestType(stack, this.CacheChestType);
            this.CacheChestType = (byte)-1;
            drops.add(stack);
        }
        return drops;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.func_72330_a((double)((float)x + f), (double)y, (double)((float)z + f), (double)((float)(x + 1) - f), (double)((float)(y + 1) - f), (double)((float)(z + 1) - f));
    }

    public void func_149719_a(IBlockAccess iBAccess, int x, int y, int z) {
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileArcaneChest chest = (TileArcaneChest)world.func_147438_o(x, y, z);
        if (chest == null) {
            return null;
        }
        ItemStack stack = new ItemStack((Block)this, 1, chest.getChestType());
        BlockArcaneChest.setChestType(stack, (byte)chest.getChestType());
        return stack;
    }
}

