/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.entity;

import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.entity.EntityOwnableCreature;
import com.trinarybrain.magianaturalis.common.entity.ai.AIFollowJumpOwner;
import com.trinarybrain.magianaturalis.common.entity.ai.AILeapAtTarget;
import com.trinarybrain.magianaturalis.common.entity.ai.AIOwnerHurtByTarget;
import com.trinarybrain.magianaturalis.common.entity.ai.AIOwnerHurtTarget;
import com.trinarybrain.magianaturalis.common.inventory.InventoryEvilTrunk;
import com.trinarybrain.magianaturalis.common.item.ItemsMN;
import com.trinarybrain.magianaturalis.common.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;

public class EntityEvilTrunk
extends EntityOwnableCreature {
    public float skullrot;
    private int jumpDelay;
    private int eatDelay;
    public InventoryEvilTrunk inventory = new InventoryEvilTrunk(this, 36);
    public String[] name = new String[]{"corrupted", "sinister", "demonic", "tainted"};

    public EntityEvilTrunk(World world, int type) {
        this(world);
        this.setTrunkType((byte)type);
    }

    public EntityEvilTrunk(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.skullrot = 0.0f;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiWait);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILeapAtTarget((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIFollowJumpOwner(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(75.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74774_a("TrunkType", this.getTrunkType());
        data.func_74782_a("Inventory", this.inventory.writeToNBT(new NBTTagList()));
    }

    @Override
    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.setTrunkType(data.func_74771_c("TrunkType"));
        NBTTagList nbttaglist = data.func_150295_c("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        if (this.eatDelay > 0) {
            --this.eatDelay;
        }
        this.field_70143_R = 0.0f;
        if (this.getOwner() != null && this.func_70638_az() != null && !this.func_70638_az().field_70128_L && this.func_70638_az() != this.getOwner()) {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
            if (this.field_70724_aR <= 0 && (double)this.func_70032_d((Entity)this.func_70638_az()) < 1.5 && this.func_70638_az().field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && this.func_70638_az().field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
                this.field_70724_aR = 10 + this.field_70170_p.field_73012_v.nextInt(5);
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.field_70170_p.func_72960_a((Entity)this, (byte)17);
                this.field_70170_p.func_72956_a((Entity)this, "mob.blaze.hit", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public boolean func_70097_a(DamageSource damage, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (damage == DamageSource.field_76371_c) {
            return false;
        }
        if (damage == DamageSource.field_76372_a) {
            return false;
        }
        if (damage == DamageSource.field_76370_b) {
            return false;
        }
        if (damage == DamageSource.field_76369_e) {
            return false;
        }
        return super.func_70097_a(damage, amount);
    }

    @Override
    public boolean canAttack(EntityLivingBase attacker, EntityLivingBase owner) {
        if (!(attacker instanceof EntityCreeper) && !(attacker instanceof EntityGhast)) {
            if (attacker instanceof EntityWolf && ((EntityWolf)attacker).func_70909_n() && ((EntityWolf)attacker).func_70902_q() == owner) {
                return false;
            }
            if (attacker instanceof EntityOwnableCreature && ((EntityOwnableCreature)attacker).getOwner() == owner) {
                return false;
            }
            return attacker instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)attacker) ? false : !(attacker instanceof EntityHorse) || !((EntityHorse)attacker).func_110248_bS();
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E && this.field_70181_x < 0.0 && !this.field_70171_ac) {
                this.skullrot += 0.015f;
            }
            if ((this.field_70122_E || this.field_70171_ac) && !this.isOpen()) {
                this.skullrot -= 0.1f;
                if (this.skullrot < 0.0f) {
                    this.skullrot = 0.0f;
                }
            }
            if (this.isOpen()) {
                this.skullrot += 0.035f;
            }
            float f = this.isOpen() ? 0.5f : 0.2f;
            if (this.skullrot > f) {
                this.skullrot = this.isOpen() ? 0.5f : 0.2f;
            }
        } else if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 50 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemFood && this.func_110143_aJ() < this.func_110138_aP()) {
                ItemFood itemfood = (ItemFood)stack.func_77973_b();
                --stack.field_77994_a;
                this.func_70691_i(itemfood.func_150905_g(stack));
                if (this.func_110143_aJ() == this.func_110138_aP()) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f);
                } else {
                    this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.skullrot = 0.15f;
                if (stack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (this.isOwner((EntityLivingBase)player) && stack.func_77973_b() == ConfigItems.itemGolemBell && !this.field_70128_L) {
                if (Platform.isClient()) {
                    this.func_70656_aK();
                    return true;
                }
                if (Platform.isServer()) {
                    ItemStack drop = new ItemStack(ItemsMN.evilTrunkSpawner, 1, (int)this.getTrunkType());
                    if (player.func_70093_af()) {
                        drop.func_77983_a("inventory", this.inventory.writeToNBT(new NBTTagList()));
                    } else {
                        this.inventory.dropAllItems();
                    }
                    this.func_70099_a(drop, 0.5f);
                    this.field_70170_p.func_72956_a((Entity)this, "thaumcraft:zap", 0.5f, 1.0f);
                    this.func_70106_y();
                    return true;
                }
            }
        }
        if (Platform.isServer() && this.isOwner((EntityLivingBase)player) && !player.func_70093_af()) {
            player.openGui((Object)MagiaNaturalis.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
            return true;
        }
        return false;
    }

    protected String func_70621_aR() {
        return Blocks.field_150363_s.field_149762_H.func_150498_e();
    }

    protected String func_70673_aS() {
        return "random.break";
    }

    public void setTrunkType(byte id) {
        this.field_70180_af.func_75692_b(14, (Object)id);
    }

    public byte getTrunkType() {
        return this.field_70180_af.func_75683_a(14);
    }

    public boolean isOpen() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    public void setOpen(boolean par1) {
        this.field_70180_af.func_75692_b(15, (Object)((byte)(par1 ? 1 : 0)));
    }

    public void setUpgrade(byte i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    public byte getUpgrade() {
        return this.field_70180_af.func_75683_a(18);
    }

    void showHeartsOrSmokeFX(boolean flag) {
        String s = "heart";
        int amount = 1;
        if (!flag) {
            s = "explode";
            amount = 7;
        }
        for (int i = 0; i < amount; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 17) {
            this.skullrot = 0.15f;
        } else if (par1 == 18) {
            this.skullrot = 0.15f;
            this.showHeartsOrSmokeFX(true);
        } else {
            super.func_70103_a(par1);
        }
    }
}

