/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.entity;

import com.trinarybrain.magianaturalis.common.entity.ai.AIWait;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.world.World;

public class EntityOwnableCreature
extends EntityCreature
implements IEntityOwnable {
    protected AIWait aiWait = new AIWait(this);

    public EntityOwnableCreature(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        if (this.getOwnerUUID() == null) {
            data.func_74778_a("OwnerUUID", "");
        } else {
            data.func_74778_a("OwnerUUID", this.getOwnerUUID());
        }
        data.func_74757_a("Waiting", this.isWaiting());
    }

    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        String s = "";
        if (data.func_150297_b("OwnerUUID", 8)) {
            s = data.func_74779_i("OwnerUUID");
        } else {
            String s1 = data.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (!s.isEmpty()) {
            this.setOwnerUUID(s);
        }
        this.aiWait.setWaiting(data.func_74767_n("Waiting"));
        this.setWaiting(data.func_74767_n("Waiting"));
    }

    public boolean isWaiting() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setWaiting(boolean bool) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(bool ? 1 : 0)));
    }

    public String func_152113_b() {
        return this.field_70180_af.func_75681_e(17);
    }

    public String getOwnerUUID() {
        return this.func_152113_b();
    }

    public void setOwnerUUID(String uuid) {
        this.field_70180_af.func_75692_b(17, (Object)uuid);
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entity) {
        return entity == this.getOwner();
    }

    public AIWait getAIWaitObj() {
        return this.aiWait;
    }

    public Team func_96124_cp() {
        EntityLivingBase owner = this.getOwner();
        if (owner != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase entity) {
        EntityLivingBase owner = this.getOwner();
        if (entity == owner) {
            return true;
        }
        if (owner != null) {
            return owner.func_142014_c(entity);
        }
        return super.func_142014_c(entity);
    }

    public boolean canAttack(EntityLivingBase attacker, EntityLivingBase owner) {
        return true;
    }
}

