/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.item;

import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.util.Platform;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class BiomeDevTool
extends Item {
    public BiomeDevTool() {
        this.field_77777_bU = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add(EnumChatFormatting.DARK_PURPLE + "Last Biome: " + stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(MagiaNaturalis.rlString("book_magia_natura"));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Platform.isClient()) {
            return stack;
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        Throwable throwable;
        BufferedWriter writer;
        if (Platform.isClient()) {
            return false;
        }
        boolean ignore = false;
        if (ignore) {
            MagiaNaturalis.LOGGER.info((Object)world.func_147439_a(x, y, z));
            MagiaNaturalis.LOGGER.info((Object)world.func_72805_g(x, y, z));
            return false;
        }
        String divider = "----------------------------------------------------";
        File mcDir = (File)FMLInjectionData.data()[6];
        File modsDir = new File(mcDir, "magia_naturalis");
        if (!modsDir.exists()) {
            modsDir.mkdirs();
        }
        File exportFile = new File(mcDir, "magia_naturalis/Biome_Types-Aspects.txt");
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(exportFile)));
            throwable = null;
            try {
                String aspectName = "";
                String types = "";
                int aura = 0;
                for (BiomeDictionary.Type type : BiomeDictionary.Type.values()) {
                    types = "[" + type.toString() + "]";
                    Aspect aspect = (Aspect)((List)BiomeHandler.biomeInfo.get(type)).get(1);
                    aura = (Integer)((List)BiomeHandler.biomeInfo.get(type)).get(0);
                    aura = Math.round((float)aura * 2.0f / 100.0f);
                    aspectName = aspect != null ? "[" + aspect.getName() + "]" : (type == BiomeDictionary.Type.MAGICAL ? "[" + Aspect.MAGIC.getName() + "]" : "[NULL]");
                    String info = String.format("%-16s :\t%dx\t%s%n", types, aura, aspectName);
                    writer.write(info);
                }
            }
            catch (Throwable aspectName) {
                throwable = aspectName;
                throw aspectName;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable aspectName) {
                            throwable.addSuppressed(aspectName);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            MagiaNaturalis.LOGGER.error("Failed to dump {}", new Object[]{exportFile.getPath(), e});
        }
        exportFile = new File(mcDir, "magia_naturalis/Biome_Composition.txt");
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(exportFile)));
            throwable = null;
            try {
                BiomeGenBase[] biomes;
                for (BiomeGenBase biome : biomes = BiomeGenBase.func_150565_n()) {
                    if (biome == null) continue;
                    String aspectName = "";
                    String types = "";
                    int aura = 0;
                    StringBuilder aspectCost = new StringBuilder();
                    for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                        types = "[" + type.toString() + "]";
                        Aspect aspect = (Aspect)((List)BiomeHandler.biomeInfo.get(type)).get(1);
                        aura = (Integer)((List)BiomeHandler.biomeInfo.get(type)).get(0);
                        aura = Math.round((float)aura * 2.0f / 100.0f);
                        aspectName = aspect != null ? "[" + aspect.getName() + "]" : (type == BiomeDictionary.Type.MAGICAL ? "[" + Aspect.MAGIC.getName() + "]" : "[NULL]");
                        aspectCost.append(String.format("%-16s :\t%dx\t%s%n", types, aura, aspectName));
                    }
                    String info = String.format(divider + "%nBiome: %s%n%s", biome.field_76791_y, aspectCost);
                    writer.write(info);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            MagiaNaturalis.LOGGER.error("Failed to dump {}", new Object[]{exportFile.getPath(), e});
        }
        return false;
    }
}

