/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.item.artifact;

import com.trinarybrain.magianaturalis.common.tile.TileGeoMorpher;
import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class ItemBiomeSampler
extends Item {
    IIcon icon_overlay;

    public ItemBiomeSampler() {
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack stack) {
        String name = NBTUtil.openNbtData(stack).func_74779_i("biomeName");
        return (name + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (GuiScreen.func_146271_m()) {
            String[] aspects = this.getAspects(stack);
            if (aspects == null) {
                return;
            }
            for (String aspect : aspects) {
                if (aspect == null) continue;
                list.add(aspect);
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + Platform.translate("hint.magianaturalis.ctrl"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("magianaturalis:report_base");
        this.icon_overlay = icon.func_94245_a("magianaturalis:report_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int renderPass) {
        return renderPass == 0 ? this.field_77791_bV : this.icon_overlay;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int i) {
        int color = NBTUtil.openNbtData(stack).func_74762_e("color");
        color = i == 0 ? 0xFFFFFF : color;
        return color;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (Platform.isClient()) {
            return false;
        }
        if (player.func_70093_af()) {
            BiomeGenBase biome = world.func_72807_a(x, z);
            if (biome != null) {
                NBTTagCompound data = NBTUtil.openNbtData(stack);
                data.func_74778_a("biomeName", biome.field_76791_y + " ");
                data.func_74768_a("biomeID", biome.field_76756_M);
                data.func_74768_a("color", biome.field_76790_z);
                BiomeDictionary.Type[] newTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                NBTTagList nbttaglist = new NBTTagList();
                NBTTagCompound tempData = new NBTTagCompound();
                for (BiomeDictionary.Type newType : newTypes) {
                    if (newType == null) continue;
                    if (newType != BiomeDictionary.Type.MAGICAL) {
                        Aspect aspect = (Aspect)((List)BiomeHandler.biomeInfo.get(newType)).get(1);
                        if (aspect == null) continue;
                        int aura = (Integer)((List)BiomeHandler.biomeInfo.get(newType)).get(0);
                        tempData.func_74777_a(aspect.getTag(), (short)Math.round((float)aura * 2.0f / 100.0f));
                        nbttaglist.func_74742_a((NBTBase)tempData);
                        continue;
                    }
                    tempData.func_74777_a(Aspect.MAGIC.getTag(), (short)2);
                    nbttaglist.func_74742_a((NBTBase)tempData);
                }
                data.func_74782_a("aspects", (NBTBase)nbttaglist);
                return true;
            }
        } else {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileGeoMorpher) {
                TileGeoMorpher geo = (TileGeoMorpher)tile;
                geo.cachedBiome = BiomeGenBase.func_150568_d((int)NBTUtil.openNbtData(stack).func_74762_e("biomeID"));
                world.func_147471_g(x, y, z);
                return true;
            }
        }
        return false;
    }

    public String[] getAspects(ItemStack stack) {
        if (stack != null) {
            NBTTagCompound data = NBTUtil.openNbtData(stack);
            if (!data.func_74764_b("aspects")) {
                return null;
            }
            NBTTagList nbttaglist = data.func_150295_c("aspects", 10);
            String[] aspects = new String[nbttaglist.func_74745_c()];
            block0: for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound tempData = nbttaglist.func_150305_b(i);
                Set keys = tempData.func_150296_c();
                int j = 0;
                for (Object ob : keys) {
                    if (!(ob instanceof String)) continue;
                    if (j >= nbttaglist.func_74745_c()) continue block0;
                    String aspectTag = (String)ob;
                    String color = Aspect.getAspect((String)aspectTag).getChatcolor();
                    if (color == null) {
                        color = "5";
                    }
                    aspects[j++] = String.format("%dx %s%s", tempData.func_74765_d(aspectTag), '\u00a7' + color, WordUtils.capitalizeFully((String)aspectTag));
                }
            }
            return aspects;
        }
        return null;
    }
}

