/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.item.artifact;

import com.mojang.authlib.GameProfile;
import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.tile.TileArcaneChest;
import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.access.TileAccess;
import com.trinarybrain.magianaturalis.common.util.access.UserAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import thaumcraft.common.tiles.TileOwned;

public class ItemKey
extends Item {
    public ItemKey() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add(EnumChatFormatting.DARK_PURPLE + Platform.translate("flavor.magianaturalis.key." + stack.func_77960_j()));
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        if (data.func_74764_b("owner") && data.func_74764_b("ownerNick")) {
            list.add("");
            list.add("Soulbound to " + data.func_74779_i("ownerNick"));
        }
        if (data.func_74764_b("forger") && data.func_74764_b("forgerNick")) {
            if (!data.func_74764_b("owner") && !data.func_74764_b("ownerNick")) {
                list.add("");
            }
            list.add("Forged by " + data.func_74779_i("forgerNick"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(MagiaNaturalis.rlString("key_thaumium"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null && (stack.func_77978_p().func_74764_b("forger") || stack.func_77978_p().func_74764_b("owner"));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public UUID getBoundPlayer(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return UUID.fromString(NBTUtil.openNbtData(stack).func_74779_i("owner"));
    }

    public boolean setBoundPlayer(ItemStack stack, GameProfile gameprofile) {
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        data.func_74778_a("owner", gameprofile.getId().toString());
        data.func_74778_a("ownerNick", gameprofile.getName());
        return true;
    }

    public UUID getKeyForger(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return UUID.fromString(NBTUtil.openNbtData(stack).func_74779_i("forger"));
    }

    public boolean setKeyForger(ItemStack stack, GameProfile gameprofile) {
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        data.func_74778_a("forger", gameprofile.getId().toString());
        data.func_74778_a("forgerNick", gameprofile.getName());
        return true;
    }

    public byte getAccessLevel(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return NBTUtil.openNbtData(stack).func_74771_c("accessLevel");
    }

    public boolean setAccessLevel(ItemStack stack, byte level) {
        if (stack == null) {
            return false;
        }
        NBTUtil.openNbtData(stack).func_74774_a("accessLevel", level);
        return true;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.setKeyForger(stack, player.func_146103_bH());
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Platform.isServer() && player.func_70093_af()) {
            NBTTagCompound data = NBTUtil.openNbtData(stack);
            if (!data.func_74764_b("forger")) {
                this.setKeyForger(stack, player.func_146103_bH());
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + String.format(Platform.translate("chat.magianaturalis.key.owner"), player.func_146103_bH().getName())));
            } else if (!data.func_74764_b("owner")) {
                this.setBoundPlayer(stack, player.func_146103_bH());
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + String.format(Platform.translate("chat.magianaturalis.key.boundplayer.1"), player.func_146103_bH().getName())));
            }
            return stack;
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (Platform.isServer()) {
            if (stack.func_77960_j() == 0) {
                NBTTagCompound data = NBTUtil.openNbtData(stack);
                if (!data.func_74764_b("forger")) {
                    return false;
                }
                if (data.func_74764_b("owner") && !UUID.fromString(data.func_74779_i("owner")).equals(this.getBoundPlayer(stack))) {
                    return false;
                }
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile == null) {
                    return false;
                }
                boolean bool = false;
                if (tile instanceof TileArcaneChest) {
                    bool = ((TileArcaneChest)tile).owner.equals(this.getKeyForger(stack));
                } else if (tile instanceof TileOwned) {
                    if (!data.func_74764_b("forgerNick")) {
                        return false;
                    }
                    bool = ((TileOwned)tile).owner.equals(stack.func_77978_p().func_74779_i("forgerNick"));
                }
                if (bool) {
                    TileAccess.addPlayerToAccesList(player, this.getAccessLevel(stack), world, x, y, z);
                }
                return bool;
            }
            if (stack.func_77960_j() == 1) {
                TileEntity tile;
                NBTTagCompound data = NBTUtil.openNbtData(stack);
                boolean hasAccess = false;
                if (data.func_74764_b("owner") && !UUID.fromString(data.func_74779_i("owner")).equals(this.getBoundPlayer(stack))) {
                    hasAccess = false;
                }
                if ((tile = world.func_147438_o(x, y, z)) == null) {
                    return false;
                }
                if (tile instanceof TileArcaneChest) {
                    TileArcaneChest chest = (TileArcaneChest)tile;
                    hasAccess = player.func_146103_bH().getId().equals(chest.owner) ? true : chest.accessList.contains(new UserAccess(player.func_110124_au(), 1));
                } else if (tile instanceof TileOwned) {
                    TileOwned owned = (TileOwned)tile;
                    hasAccess = player.func_146103_bH().getName().equals(owned.owner) ? true : owned.accessList.contains(1 + player.func_146103_bH().getName());
                }
                if (!hasAccess) {
                    return false;
                }
                if (!data.func_74764_b("AccessList")) {
                    return false;
                }
                NBTTagList accessList = data.func_150295_c("AccessList", 10);
                for (int i = 0; i < accessList.func_74745_c(); ++i) {
                    NBTTagCompound tempData = accessList.func_150305_b(i);
                    TileAccess.addPlayerToAccesList(new GameProfile(UUID.fromString(tempData.func_74779_i("UUID")), tempData.func_74779_i("Nick")), tempData.func_74771_c("Type"), world, x, y, z);
                }
                return true;
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (stack.func_77960_j() == 0) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            EntityPlayer player2 = (EntityPlayer)entity;
            boolean bool = this.setBoundPlayer(stack, player2.func_146103_bH());
            if (bool) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + String.format(Platform.translate("chat.magianaturalis.key.boundplayer"), player2.func_146103_bH().getName())));
            }
        } else if (stack.func_77960_j() == 1) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            EntityPlayer player2 = (EntityPlayer)entity;
            NBTTagCompound data = NBTUtil.openNbtData(stack);
            NBTTagList accessList = !data.func_74764_b("AccessList") ? new NBTTagList() : data.func_150295_c("AccessList", 10);
            NBTTagCompound tempData = new NBTTagCompound();
            tempData.func_74778_a("UUID", player2.func_146103_bH().getId().toString());
            tempData.func_74778_a("Nick", player2.func_146103_bH().getName());
            tempData.func_74774_a("Type", data.func_74771_c("AccessLevel"));
            accessList.func_74742_a((NBTBase)tempData);
            data.func_74782_a("AccessList", (NBTBase)accessList);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + String.format(Platform.translate("chat.magianaturalis.key.accesslist"), player2.func_146103_bH().getName())));
        }
        return false;
    }
}

