/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.item.focus;

import com.trinarybrain.magianaturalis.common.MagiaNaturalis;
import com.trinarybrain.magianaturalis.common.core.KeyHandler;
import com.trinarybrain.magianaturalis.common.util.FocusBuildHelper;
import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.WorldCoord;
import com.trinarybrain.magianaturalis.common.util.WorldUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.BlockCoordinates;
import thaumcraft.api.IArchitect;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusBuild
extends ItemFocusBasic
implements IArchitect {
    protected static final AspectList VIS_COST = new AspectList().add(Aspect.ORDER, 5).add(Aspect.EARTH, 5);
    public static double reachDistance = 5.0;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        super.func_77624_a(stack, player, lines, advancedItemTooltips);
        lines.add("");
        lines.add(EnumChatFormatting.DARK_GRAY + "Meta: " + (Object)((Object)FocusBuildHelper.getMeta(stack)));
        lines.add(EnumChatFormatting.DARK_GRAY + "Shape: " + (Object)((Object)FocusBuildHelper.getShape(stack)) + "  Size: " + FocusBuildHelper.getSize(stack));
        lines.add("");
        lines.add(String.format("%sPress [%s] or [%s] to change size of Shape", EnumChatFormatting.DARK_GRAY, GameSettings.func_74298_c((int)KeyHandler.INCREASE_SIZE_KEY.func_151463_i()), GameSettings.func_74298_c((int)KeyHandler.DECREASE_SIZE_KEY.func_151463_i())));
        lines.add(String.format("%sPress [%s] to change Shape", EnumChatFormatting.DARK_GRAY, GameSettings.func_74298_c((int)KeyHandler.MISC_KEY.func_151463_i())));
        lines.add(String.format("%sPress [%s] to pick block type.", EnumChatFormatting.DARK_GRAY, GameSettings.func_74298_c((int)KeyHandler.PICK_BLOCK_KEY.func_151463_i())));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        ItemStack stack = new ItemStack(item, 1, 0);
        this.applyUpgrade(stack, FocusUpgradeType.architect, 1);
        FocusBuildHelper.setSize(stack, 1);
        FocusBuildHelper.setShape(stack, FocusBuildHelper.Shape.CUBE);
        list.add(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.icon = registry.func_94245_a(MagiaNaturalis.rlString("focus_build"));
    }

    public int getFocusColor(ItemStack focusStack) {
        return 8747923;
    }

    public AspectList getVisCost(ItemStack focusStack) {
        return VIS_COST;
    }

    public int getMaxAreaSize(ItemStack focusStack) {
        return 3 + this.getUpgradeLevel(focusStack, FocusUpgradeType.enlarge) * 3 + 1;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusStack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.enlarge, FocusUpgradeType.frugal};
    }

    public ItemStack onFocusRightClick(ItemStack wandStack, World world, EntityPlayer player, MovingObjectPosition movingObjectPosition) {
        player.func_71038_i();
        if (Platform.isClient()) {
            return wandStack;
        }
        MovingObjectPosition target = WorldUtil.getMovingObjectPositionFromPlayer(world, player, reachDistance, true);
        if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            float hitX = (float)(target.field_72307_f.field_72450_a - (double)x);
            float hitY = (float)(target.field_72307_f.field_72448_b - (double)y);
            float hitZ = (float)(target.field_72307_f.field_72449_c - (double)z);
            if (!this.onFocusUse(wandStack, player, world, x, y, z, target.field_72310_e, hitX = Math.abs(hitX), hitY = Math.abs(hitY), hitZ = Math.abs(hitZ))) {
                world.func_72956_a((Entity)player, "thaumcraft:wandfail", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
            }
        }
        return wandStack;
    }

    public boolean onFocusUse(ItemStack wandStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.field_71075_bZ.field_75099_e) {
            return false;
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        ItemStack focusStack = wand.getFocusItem(wandStack);
        int size = FocusBuildHelper.getSize(focusStack);
        if (size < 1 || size > this.getMaxAreaSize(focusStack)) {
            return false;
        }
        FocusBuildHelper.Shape shape = FocusBuildHelper.getShape(focusStack);
        if (shape == FocusBuildHelper.Shape.NONE) {
            return false;
        }
        Block pblock = null;
        int pbdata = 0;
        if (FocusBuildHelper.getMeta(focusStack) == FocusBuildHelper.Meta.UNIFORM) {
            pblock = world.func_147439_a(x, y, z);
            pbdata = world.func_72805_g(x, y, z);
        } else {
            int[] i = FocusBuildHelper.getPickedBlock(focusStack);
            pblock = Block.func_149729_e((int)i[0]);
            pbdata = i[1];
        }
        if (pblock == null || pblock == Blocks.field_150350_a) {
            return false;
        }
        if (pbdata < 0 || pbdata > 15) {
            return false;
        }
        return this.buildAction(wandStack, player, world, x, y, z, side, hitX, hitY, hitZ, size, pblock, pbdata);
    }

    private boolean buildAction(ItemStack wandStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int size, Block pickedblock, int pbData) {
        List<WorldCoord> blocks = null;
        ForgeDirection face = ForgeDirection.getOrientation((int)side);
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        switch (FocusBuildHelper.getShape(wand.getFocusItem(wandStack))) {
            case CUBE: {
                blocks = WorldUtil.plot3DCubeArea(player, world, x += face.offsetX * size, y += face.offsetY * size, z += face.offsetZ * size, side, hitX, hitY, hitZ, size);
                break;
            }
            case PLANE: {
                blocks = WorldUtil.plot2DPlane(player, world, x += face.offsetX, y += face.offsetY, z += face.offsetZ, side, hitX, hitY, hitZ, size);
                break;
            }
            case PLANE_EXTEND: {
                blocks = WorldUtil.plot2DPlaneExtension(player, world, x += face.offsetX * (size + 1) / 2, y += face.offsetY * (size + 1) / 2, z += face.offsetZ * (size + 1) / 2, side, hitX, hitY, hitZ, size);
                break;
            }
            case SPHERE: {
                blocks = WorldUtil.plot3DCubeArea(player, world, x += face.offsetX * size, y += face.offsetY * size, z += face.offsetZ * size, side, hitX, hitY, hitZ, size);
                break;
            }
        }
        if (blocks == null || blocks.isEmpty()) {
            return false;
        }
        int ls = blocks.size();
        if (!player.field_71075_bZ.field_75098_d) {
            double costD = blocks.size() * 5;
            if (costD > (double)wand.getVis(wandStack, Aspect.ORDER)) {
                int i;
                ls = i = blocks.size() - (blocks.size() - wand.getVis(wandStack, Aspect.ORDER) / 5);
            }
            if (ls == 0) {
                return false;
            }
            ItemStack tempStack = new ItemStack(pickedblock, 1, pbData);
            if (tempStack.func_77973_b() != null) {
                int itemAmount = 0;
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(tempStack)) continue;
                    itemAmount += player.field_71071_by.field_70462_a[i].field_77994_a;
                }
                if (itemAmount < ls) {
                    ls = itemAmount;
                }
                if (ls == 0) {
                    return false;
                }
                for (int j = 0; j < ls; ++j) {
                    player.field_71071_by.func_146026_a(tempStack.func_77973_b());
                }
                player.field_71069_bz.func_75142_b();
                int costN = 5 * ls;
                if (!ThaumcraftApiHelper.consumeVisFromWand((ItemStack)wandStack, (EntityPlayer)player, (AspectList)new AspectList().add(Aspect.ORDER, costN).add(Aspect.EARTH, costN), (boolean)true, (boolean)false)) {
                    return false;
                }
            } else {
                ls = 0;
            }
        }
        if (ls == 0) {
            return false;
        }
        for (int i = 0; i < ls; ++i) {
            WorldCoord temp = (WorldCoord)((Object)blocks.get(i));
            world.func_147465_d(temp.x, temp.y, temp.z, pickedblock, pbData, 3);
        }
        return true;
    }

    public ArrayList<BlockCoordinates> getArchitectBlocks(ItemStack stack, World world, int x, int y, int z, int side, EntityPlayer player) {
        MovingObjectPosition target = WorldUtil.getMovingObjectPositionFromPlayer(world, player, reachDistance, true);
        if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = target.field_72311_b;
            y = target.field_72312_c;
            z = target.field_72309_d;
            Block block1 = player.field_70170_p.func_147439_a(x, y, z);
            if (block1 == null) {
                return null;
            }
            int b1damage = block1.func_149643_k(player.field_70170_p, x, y, z);
            if (stack != null) {
                ItemStack stackFocus = null;
                if (stack.func_77973_b() instanceof ItemWandCasting) {
                    ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
                    stackFocus = wand.getFocusItem(stack);
                } else if (stack.func_77973_b() instanceof ItemFocusBuild) {
                    stackFocus = stack;
                } else {
                    return null;
                }
                float hitX = (float)(target.field_72307_f.field_72450_a - (double)x);
                float hitY = (float)(target.field_72307_f.field_72448_b - (double)y);
                float hitZ = (float)(target.field_72307_f.field_72449_c - (double)z);
                hitX = Math.abs(hitX);
                hitY = Math.abs(hitY);
                hitZ = Math.abs(hitZ);
                ForgeDirection face = ForgeDirection.getOrientation((int)target.field_72310_e);
                ArrayList blocks = null;
                int size = FocusBuildHelper.getSize(stackFocus);
                if (size < 1 || size > this.getMaxAreaSize(stackFocus)) {
                    return null;
                }
                switch (FocusBuildHelper.getShape(stackFocus)) {
                    case CUBE: {
                        blocks = (ArrayList)WorldUtil.plot3DCubeArea(player, player.field_70170_p, x += face.offsetX * size, y += face.offsetY * size, z += face.offsetZ * size, target.field_72310_e, hitX, hitY, hitZ, size);
                        break;
                    }
                    case PLANE: {
                        blocks = (ArrayList)WorldUtil.plot2DPlane(player, player.field_70170_p, x += face.offsetX, y += face.offsetY, z += face.offsetZ, target.field_72310_e, hitX, hitY, hitZ, size);
                        break;
                    }
                    case PLANE_EXTEND: {
                        blocks = (ArrayList)WorldUtil.plot2DPlaneExtension(player, player.field_70170_p, x += face.offsetX * (size + 1) / 2, y += face.offsetY * (size + 1) / 2, z += face.offsetZ * (size + 1) / 2, target.field_72310_e, hitX, hitY, hitZ, size);
                        break;
                    }
                    case SPHERE: {
                        blocks = (ArrayList)WorldUtil.plot3DCubeArea(player, player.field_70170_p, x += face.offsetX * size, y += face.offsetY * size, z += face.offsetZ * size, target.field_72310_e, hitX, hitY, hitZ, size);
                        break;
                    }
                }
                return blocks;
            }
        }
        return null;
    }

    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, int side, IArchitect.EnumAxis axis) {
        return false;
    }
}

