/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.tile;

import com.mojang.authlib.GameProfile;
import com.trinarybrain.magianaturalis.common.block.BlockArcaneChest;
import com.trinarybrain.magianaturalis.common.block.BlocksMN;
import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.access.UserAccess;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.wands.IWandable;

public class TileArcaneChest
extends TileThaumcraft
implements ISidedInventory,
IWandable {
    private ItemStack[] inventory = new ItemStack[54];
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    public UUID owner;
    private String ownerName;
    public ArrayList<UserAccess> accessList = new ArrayList();
    private byte chestType = 0;
    public final String[] name = new String[]{"unknown", "gw", "sw"};
    private String customName;
    private static final int[] sides = new int[]{0, 1, 2, 3, 4, 5};

    public String getOwnerName() {
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            return this.ownerName;
        }
        if (Platform.isServer() && this.owner != null) {
            GameProfile profile = Platform.findGameProfileByUUID(this.owner);
            if (profile != null) {
                this.ownerName = profile.getName();
                return this.ownerName;
            }
            this.ownerName = "Only UUID Available";
            return "Only UUID Available";
        }
        return "Unknown";
    }

    public int func_70302_i_() {
        return this.getChestType() == 2 ? 77 : 54;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.inventory[index] == null) {
            return null;
        }
        if (this.inventory[index].field_77994_a <= amount) {
            ItemStack stack = this.inventory[index];
            this.inventory[index] = null;
            return stack;
        }
        ItemStack stack = this.inventory[index].func_77979_a(amount);
        if (this.inventory[index].field_77994_a == 0) {
            this.inventory[index] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] == null) {
            return null;
        }
        ItemStack stack = this.inventory[index];
        this.inventory[index] = null;
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setInvetory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : Platform.translate("tile.magianaturalis:arcaneChest." + this.name[this.getChestType()] + ".name");
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setGuiName(String name) {
        this.customName = name;
    }

    public int getChestType() {
        return this.chestType;
    }

    public void setChestType(byte type) {
        this.chestType = type;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory = NBTUtil.loadInventoryFromNBT(data, this.func_70302_i_());
        if (data.func_74764_b("CustomName")) {
            this.customName = data.func_74779_i("CustomName");
        }
    }

    public void readCustomNBT(NBTTagCompound data) {
        this.owner = UUID.fromString(data.func_74779_i("owner"));
        this.chestType = data.func_74771_c("Type");
        this.accessList = NBTUtil.loadUserAccessFromNBT(data);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        NBTUtil.saveInventoryToNBT(data, this.inventory);
        if (this.func_145818_k_()) {
            data.func_74778_a("CustomName", this.customName);
        }
    }

    public void writeCustomNBT(NBTTagCompound data) {
        data.func_74778_a("owner", this.owner.toString());
        data.func_74774_a("Type", this.chestType);
        NBTUtil.saveUserAccessToNBT(data, this.accessList);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlocksMN.arcaneChest, 1, this.numUsingPlayers);
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlocksMN.arcaneChest, 1, this.numUsingPlayers);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return sides;
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.prevLidAngle = this.lidAngle;
        float angle = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float currAngle = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angle) : (this.lidAngle -= angle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && currAngle >= 0.5f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int eventID, int arg) {
        if (eventID == 1) {
            this.numUsingPlayers = arg;
            return true;
        }
        if (eventID == 2) {
            if (this.lidAngle < (float)arg / 10.0f) {
                this.lidAngle = (float)arg / 10.0f;
            }
            return true;
        }
        return this.field_145846_f;
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack stack, EntityPlayer player) {
        if (Platform.isServer() && !world.restoringBlockSnapshots) {
            boolean hasAccess = false;
            hasAccess = player.field_71075_bZ.field_75098_d || this.owner.equals(player.func_146103_bH().getId()) ? true : this.accessList.contains(new UserAccess(player.func_146103_bH().getId(), 2));
            if (!hasAccess) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + Platform.translate("chat.magianaturalis.chest.resist")));
                return stack;
            }
            Block block = world.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (block == null) {
                return stack;
            }
            ItemStack stack1 = new ItemStack(BlocksMN.arcaneChest, 1, (int)this.chestType);
            BlockArcaneChest.setChestType(stack1, this.chestType);
            NBTUtil.saveInventoryToNBT(stack1, this.inventory);
            if (!this.accessList.isEmpty()) {
                NBTUtil.saveUserAccessToNBT(stack1, this.accessList);
            }
            world.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            world.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)this.field_145851_c + d0, (double)this.field_145848_d + d1, (double)this.field_145849_e + d2, stack1);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        return stack;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }
}

