/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.tile;

import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.WorldUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.blocks.BlockCosmeticSolid;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockSparkle;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class TileGeoMorpher
extends TileThaumcraft
implements IAspectContainer,
IWandable {
    public int ticks = 0;
    public BiomeGenBase cachedBiome = null;
    public boolean idle = true;
    int morphX = 0;
    int morphZ = 0;
    BiomeGenBase lastBiome = null;
    AspectList morphCost = new AspectList();
    AspectList realCost = new AspectList();

    public void func_145845_h() {
        if (!Platform.isServer()) {
            return;
        }
        boolean update = false;
        if (!this.idle && ++this.ticks % 5 == 0) {
            if (this.validateStructure()) {
                update = this.handleBiomeMorphing(8, this.cachedBiome);
            } else {
                this.idle = true;
                this.realCost = new AspectList();
                update = true;
                if (this.morphX == 0) {
                    --this.morphZ;
                    this.morphX = 1024;
                } else {
                    --this.morphX;
                }
            }
        }
        if (update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public boolean validateStructure() {
        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1 - i, this.field_145849_e);
            if (block instanceof BlockCosmeticSolid && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1 - i, this.field_145849_e) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean handleBiomeMorphing(int radius, BiomeGenBase newBiome) {
        int posZ;
        boolean update = false;
        boolean isComplete = false;
        if (this.realCost.visSize() > 0) {
            for (Aspect aspect : this.realCost.getAspects()) {
                if (this.realCost.getAmount(aspect) <= 0 || !EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)aspect, (ForgeDirection)ForgeDirection.UNKNOWN, (int)12)) continue;
                this.realCost.reduce(aspect, 1);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
                break;
            }
            if (this.realCost.visSize() <= 0) {
                isComplete = true;
                update = true;
                this.realCost = new AspectList();
                int posX = this.field_145851_c - radius + this.morphX;
                posZ = this.field_145849_e - radius + this.morphZ;
                int posY = this.field_145850_b.func_72825_h(posX, posZ);
                WorldUtil.setBiomeAt(this.field_145850_b, posX, posZ, newBiome);
                this.field_145850_b.func_72938_d(posX, posZ).func_76630_e();
                this.field_145850_b.func_147471_g(posX, posY, posZ);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(this.field_145851_c, this.field_145848_d, this.field_145849_e, newBiome.field_76790_z), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
            }
        } else {
            isComplete = true;
        }
        if (isComplete && this.ticks % 20 == 0) {
            if (this.morphZ < radius * 2) {
                if (this.morphX < radius * 2) {
                    ++this.morphX;
                } else {
                    this.morphX = 0;
                    ++this.morphZ;
                }
                int posX = this.field_145851_c - radius + this.morphX;
                posZ = this.field_145849_e - radius + this.morphZ;
                BiomeGenBase oldBiome = this.field_145850_b.func_72807_a(posX, posZ);
                if (newBiome != oldBiome && Math.sqrt((this.morphX - radius) * (this.morphX - radius) + (this.morphZ - radius) * (this.morphZ - radius)) <= (double)radius) {
                    if (this.lastBiome != newBiome) {
                        this.lastBiome = newBiome;
                        this.morphCost = this.calculateMorphCost(newBiome);
                    }
                    this.realCost = this.morphCost.copy();
                    return true;
                }
            } else {
                this.morphZ = 0;
                this.idle = true;
                update = true;
            }
        }
        return update;
    }

    public AspectList calculateMorphCost(BiomeGenBase newBiome) {
        BiomeDictionary.Type[] biomeTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)newBiome);
        AspectList aspectCost = new AspectList();
        for (BiomeDictionary.Type biomeType : biomeTypes) {
            if (biomeType == null) continue;
            if (biomeType != BiomeDictionary.Type.MAGICAL) {
                Aspect aspect = (Aspect)((List)BiomeHandler.biomeInfo.get(biomeType)).get(1);
                if (aspect == null) continue;
                int aura = (Integer)((List)BiomeHandler.biomeInfo.get(biomeType)).get(0);
                aspectCost.add(aspect, Math.round((float)aura * 2.0f / 100.0f));
                continue;
            }
            aspectCost.add(Aspect.MAGIC, 2);
        }
        return aspectCost;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.morphX = data.func_74771_c("morphX");
        this.morphZ = data.func_74771_c("morphZ");
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("morphX", (byte)this.morphX);
        data.func_74774_a("morphZ", (byte)this.morphZ);
    }

    public void readCustomNBT(NBTTagCompound data) {
        this.realCost.readFromNBT(data);
        this.idle = data.func_74767_n("idle");
        int id = data.func_74762_e("biomeID");
        this.cachedBiome = id >= 0 ? BiomeGenBase.func_150568_d((int)id) : null;
    }

    public void writeCustomNBT(NBTTagCompound data) {
        this.realCost.writeToNBT(data);
        data.func_74757_a("idle", this.idle);
        data.func_74768_a("biomeID", this.cachedBiome != null ? this.cachedBiome.field_76756_M : -1);
    }

    public AspectList getAspects() {
        return this.realCost;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public int onWandRightClick(World world, ItemStack wandStack, EntityPlayer player, int x, int y, int z, int side, int md) {
        if (player.func_70093_af()) {
            this.realCost = this.calculateMorphCost(this.cachedBiome);
        } else {
            this.idle = !this.idle;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return -1;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandStack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandStack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandStack, World world, EntityPlayer player, int count) {
    }
}

