/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.tile;

import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.monster.EntityTaintacle;
import thaumcraft.common.tiles.TileJar;

public class TileJarPrison
extends TileJar
implements IWandable {
    private NBTTagCompound entityData = new NBTTagCompound();
    private Entity cachedEntity;

    public Entity getCachedEntity() {
        return this.cachedEntity;
    }

    private void setEntityForCache(NBTTagCompound data) {
        this.cachedEntity = null;
        if (data == null) {
            return;
        }
        if (data.func_74764_b("entity")) {
            this.cachedEntity = EntityList.func_75615_a((NBTTagCompound)data.func_74775_l("entity"), (World)this.func_145831_w());
            if (this.cachedEntity != null && this.cachedEntity instanceof EntityTaintacle) {
                this.cachedEntity.field_70173_aa = 30;
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound data) {
        data.func_74782_a("entity", (NBTBase)this.entityData);
    }

    public void readCustomNBT(NBTTagCompound data) {
        this.entityData = data.func_74775_l("entity");
        this.setEntityForCache(this.entityData);
    }

    public void setEntityData(NBTTagCompound data) {
        this.entityData = data;
        this.setEntityForCache(this.entityData);
    }

    public boolean saveEntityToNBT(EntityLivingBase entity) {
        if (Platform.isClient()) {
            return false;
        }
        if (entity == null || entity instanceof IBossDisplayData || entity instanceof EntityPlayer) {
            return false;
        }
        if (!(entity instanceof EntityCreature)) {
            return false;
        }
        if (!entity.func_98035_c(this.entityData)) {
            return false;
        }
        entity.func_70106_y();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean hasEntityInside() {
        return this.entityData != null && this.entityData.func_74764_b("entity");
    }

    public NBTTagCompound getEntityData() {
        return this.hasEntityInside() ? null : this.entityData.func_74775_l("entity");
    }

    public NBTTagCompound getEntityDataPrimitive() {
        return this.entityData;
    }

    public void releaseFromContainer() {
        if (Platform.isServer() && NBTUtil.spawnEntityFromNBT(this.entityData.func_74775_l("entity"), this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5)) {
            this.entityData = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        if (this.hasEntityInside()) {
            if (Platform.isServer()) {
                world.func_147468_f(x, y, z);
                this.releaseFromContainer();
            }
            this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)ConfigBlocks.blockJar) + 61440);
            player.field_70170_p.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.glass", 1.0f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
            player.func_71038_i();
            return 0;
        }
        return -1;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }
}

