/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.util;

import com.trinarybrain.magianaturalis.common.util.NBTUtil;
import com.trinarybrain.magianaturalis.common.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class FocusBuildHelper {
    public static Meta getMeta(ItemStack stack) {
        if (stack == null) {
            return Meta.NONE;
        }
        NBTTagList nbttaglist = NBTUtil.openNbtData(stack).func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            return Meta.NONE;
        }
        byte i = nbttaglist.func_150305_b(0).func_74771_c("meta");
        switch (i) {
            case 0: {
                return Meta.NONE;
            }
            case 1: {
                return Meta.UNIFORM;
            }
        }
        return Meta.NONE;
    }

    public static boolean setMeta(ItemStack stack, Meta meta) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        NBTTagList nbttaglist = data.func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            nbttaglist = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = nbttaglist.func_150305_b(0);
        }
        tempData.func_74774_a("meta", (byte)meta.ordinal());
        nbttaglist.func_74742_a((NBTBase)tempData);
        if (nbttaglist.func_74745_c() > 0) {
            data.func_74782_a("magia_naturalis", (NBTBase)nbttaglist);
            return true;
        }
        return false;
    }

    public static Shape getShape(ItemStack stack) {
        if (stack == null) {
            return Shape.NONE;
        }
        NBTTagList nbttaglist = NBTUtil.openNbtData(stack).func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            return Shape.NONE;
        }
        return FocusBuildHelper.getShapeByID(nbttaglist.func_150305_b(0).func_74771_c("shape"));
    }

    public static boolean setShape(ItemStack stack, Shape shape) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        NBTTagList nbttaglist = data.func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            nbttaglist = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = nbttaglist.func_150305_b(0);
        }
        tempData.func_74774_a("shape", (byte)shape.ordinal());
        nbttaglist.func_74742_a((NBTBase)tempData);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a("magia_naturalis", (NBTBase)nbttaglist);
            return true;
        }
        return false;
    }

    public static int getSize(ItemStack stack) {
        if (stack == null) {
            return 1;
        }
        NBTTagList nbttaglist = NBTUtil.openNbtData(stack).func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            return 1;
        }
        return nbttaglist.func_150305_b(0).func_74771_c("size");
    }

    public static boolean setSize(ItemStack stack, int size) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.openNbtData(stack);
        NBTTagList nbttaglist = data.func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            nbttaglist = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = nbttaglist.func_150305_b(0);
        }
        tempData.func_74774_a("size", (byte)size);
        nbttaglist.func_74742_a((NBTBase)tempData);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a("magia_naturalis", (NBTBase)nbttaglist);
            return true;
        }
        return false;
    }

    public static boolean setpickedBlock(ItemStack stack, Block block, int metadata) {
        NBTTagCompound nbttagcompound;
        NBTTagCompound data;
        NBTTagList nbttaglist;
        if (stack == null) {
            return false;
        }
        int bid = Block.func_149682_b((Block)block);
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((nbttaglist = (data = NBTUtil.openNbtData(stack)).func_150295_c("magia_naturalis", 10)) == null) {
            nbttaglist = new NBTTagList();
            nbttagcompound = new NBTTagCompound();
        } else {
            nbttagcompound = nbttaglist.func_150305_b(0);
        }
        nbttagcompound.func_74768_a("bid", bid);
        nbttagcompound.func_74774_a("bdata", (byte)metadata);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a("magia_naturalis", (NBTBase)nbttaglist);
            return true;
        }
        return false;
    }

    public static int[] getPickedBlock(ItemStack stack) {
        int[] i = new int[]{0, 0};
        if (stack == null) {
            return i;
        }
        NBTTagList nbttaglist = NBTUtil.openNbtData(stack).func_150295_c("magia_naturalis", 10);
        if (nbttaglist == null) {
            return i;
        }
        i[0] = nbttaglist.func_150305_b(0).func_74762_e("bid");
        i[1] = nbttaglist.func_150305_b(0).func_74771_c("bdata");
        return i;
    }

    public static Shape getShapeByID(int i) {
        switch (i) {
            case 1: {
                return Shape.PLANE;
            }
            case 2: {
                return Shape.CUBE;
            }
            case 3: {
                return Shape.PLANE_EXTEND;
            }
            case 4: {
                return Shape.SPHERE;
            }
        }
        return Shape.NONE;
    }

    public static enum Shape {
        NONE,
        PLANE,
        CUBE,
        PLANE_EXTEND,
        SPHERE;


        public String toString() {
            switch (this) {
                case CUBE: {
                    return Platform.translate("enum.magianaturalis.shape.cube");
                }
                case NONE: {
                    return Platform.translate("enum.magianaturalis.none");
                }
                case PLANE: {
                    return Platform.translate("enum.magianaturalis.shape.plane");
                }
                case PLANE_EXTEND: {
                    return Platform.translate("enum.magianaturalis.shape.plane.extend");
                }
                case SPHERE: {
                    return Platform.translate("enum.magianaturalis.shape.sphere");
                }
            }
            return Platform.translate("enum.magianaturalis.unknown");
        }
    }

    public static enum Meta {
        NONE,
        UNIFORM;


        public String toString() {
            switch (this) {
                case NONE: {
                    return Platform.translate("enum.magianaturalis.none");
                }
                case UNIFORM: {
                    return Platform.translate("enum.magianaturalis.meta.uniform");
                }
            }
            return Platform.translate("enum.magianaturalis.unknown");
        }
    }
}

