/*
 * Decompiled with CFR 0.152.
 */
package com.trinarybrain.magianaturalis.common.util;

import com.trinarybrain.magianaturalis.common.network.PacketHandler;
import com.trinarybrain.magianaturalis.common.network.packet.PacketBiomeChange;
import com.trinarybrain.magianaturalis.common.util.FocusBuildHelper;
import com.trinarybrain.magianaturalis.common.util.Platform;
import com.trinarybrain.magianaturalis.common.util.WorldCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.items.wands.ItemWandCasting;

public class WorldUtil {
    public static List<WorldCoord> plot2DPlane(EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int size) {
        List<WorldCoord> blocks = WorldUtil.plotHelper(new WorldCoord(x, y, z), new WorldCoord(x, y, z), ForgeDirection.getOrientation((int)side), hitX, hitY, hitZ, size);
        WorldCoord a = new WorldCoord(x, y, z);
        WorldCoord b = new WorldCoord(x, y, z);
        if (blocks.size() == 2) {
            a = blocks.get(0);
            b = blocks.get(1);
        }
        return WorldUtil.plot3DCubeArea(player, world, a, b, x, y, z);
    }

    public static List<WorldCoord> plot2DPlaneExtension(EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int size) {
        ForgeDirection face = ForgeDirection.getOrientation((int)side);
        int id = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (face) {
            case DOWN: 
            case UP: {
                face = ForgeDirection.getOrientation((int)Direction.field_71582_c[id]);
                break;
            }
            case EAST: 
            case WEST: {
                face = ForgeDirection.getOrientation((int)Direction.field_71582_c[id]);
                if (face != ForgeDirection.EAST && face != ForgeDirection.WEST) break;
                face = ForgeDirection.DOWN;
                break;
            }
            case NORTH: 
            case SOUTH: {
                face = ForgeDirection.getOrientation((int)Direction.field_71582_c[id]);
                if (face != ForgeDirection.NORTH && face != ForgeDirection.SOUTH) break;
                face = ForgeDirection.DOWN;
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        List<WorldCoord> blocks = WorldUtil.plotHelper(new WorldCoord(x, y, z), new WorldCoord(x, y, z), face, hitX, hitY, hitZ, size);
        WorldCoord a = new WorldCoord(x, y, z);
        WorldCoord b = new WorldCoord(x, y, z);
        if (blocks.size() == 2) {
            a = blocks.get(0);
            b = blocks.get(1);
        }
        return WorldUtil.plot3DCubeArea(player, world, a, b, x, y, z);
    }

    public static List<WorldCoord> plot3DCubeArea(EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int size) {
        ForgeDirection face = ForgeDirection.getOrientation((int)side);
        List<WorldCoord> blocks = WorldUtil.plotHelper(new WorldCoord(x, y, z), new WorldCoord(x, y, z), face, hitX, hitY, hitZ, size);
        WorldCoord a = new WorldCoord(x, y, z);
        WorldCoord b = new WorldCoord(x, y, z);
        if (blocks.size() == 2) {
            a = blocks.get(0);
            b = blocks.get(1);
        }
        a.add(face.getOpposite(), size - 1);
        return WorldUtil.plot3DCubeArea(player, world, a, b, x, y, z);
    }

    public static List<WorldCoord> plot3DCubeArea(EntityPlayer player, World world, WorldCoord P1, WorldCoord P2, int ox, int oy, int oz) {
        ArrayList<WorldCoord> blocks = new ArrayList<WorldCoord>();
        if (world == null) {
            return blocks;
        }
        Block block1 = world.func_147439_a(P1.x, P1.y, P1.z);
        Block block2 = world.func_147439_a(P2.x, P2.y, P2.z);
        if (block1 == null || block2 == null) {
            return blocks;
        }
        if (player == null || player instanceof FakePlayer) {
            return blocks;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemWandCasting) {
            ItemStack stack = player.func_71045_bC();
            ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
            Block oBlock = world.func_147439_a(ox, oy, oz);
            int oBD = world.func_72805_g(ox, oy, oz);
            FocusBuildHelper.Meta lmeta = FocusBuildHelper.getMeta(wand.getFocusItem(stack));
            FocusBuildHelper.Shape lshape = FocusBuildHelper.getShape(wand.getFocusItem(stack));
            int lsize = FocusBuildHelper.getSize(wand.getFocusItem(stack));
            int disX = Math.abs(P1.x - P2.x);
            int disY = Math.abs(P1.y - P2.y);
            int disZ = Math.abs(P1.z - P2.z);
            int minX = Math.min(P1.x, P2.x);
            int minY = Math.min(P1.y, P2.y);
            int minZ = Math.min(P1.z, P2.z);
            for (int x = 0; x <= disX; ++x) {
                for (int y = 0; y <= disY; ++y) {
                    for (int z = 0; z <= disZ; ++z) {
                        int tempX = minX + x;
                        int tempY = minY + y;
                        int tempZ = minZ + z;
                        Block lb = world.func_147439_a(tempX, tempY, tempZ);
                        if (!lb.func_149742_c(world, tempX, tempY, tempZ)) continue;
                        if (lshape == FocusBuildHelper.Shape.SPHERE) {
                            double d0;
                            if (lsize % 2 == 0) {
                                ++lsize;
                            }
                            if (!((d0 = (double)(Math.abs(x - lsize / 2) + Math.abs(y - lsize / 2) + Math.abs(z - lsize / 2))) <= (double)(lsize / 2))) continue;
                            blocks.add(new WorldCoord(tempX, tempY, tempZ));
                            continue;
                        }
                        blocks.add(new WorldCoord(tempX, tempY, tempZ));
                    }
                }
            }
        }
        return blocks;
    }

    public static List<WorldCoord> plotVeinArea(EntityPlayer player, World world, int x, int y, int z, int size) {
        ArrayList<WorldCoord> blocklist = new ArrayList<WorldCoord>();
        if (world == null) {
            return blocklist;
        }
        if (player == null || player instanceof FakePlayer) {
            return blocklist;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null) {
            return blocklist;
        }
        int blocks = 0;
        LinkedList<WorldCoord> next = new LinkedList<WorldCoord>();
        next.add(new WorldCoord(x, y, z));
        while (blocks < size && !next.isEmpty()) {
            LinkedList<WorldCoord> temp = next;
            next = new LinkedList();
            for (WorldCoord wc : temp) {
                Block lblock = world.func_147439_a(wc.x, wc.y, wc.z);
                int lmeta = world.func_72805_g(wc.x, wc.y, wc.z);
                if (!world.func_72962_a(player, wc.x, wc.y, wc.z) || lblock.func_149688_o() == Material.field_151579_a || !(lblock.func_149712_f(world, wc.x, wc.y, wc.z) >= 0.0f) || lblock != block || lmeta != meta) continue;
                ++blocks;
                WorldCoord tempWC = new WorldCoord(wc.x, wc.y, wc.z);
                if (!blocklist.contains((Object)tempWC)) {
                    blocklist.add(tempWC);
                }
                next.add(new WorldCoord(wc.x + 1, wc.y, wc.z));
                next.add(new WorldCoord(wc.x - 1, wc.y, wc.z));
                next.add(new WorldCoord(wc.x, wc.y + 1, wc.z));
                next.add(new WorldCoord(wc.x, wc.y - 1, wc.z));
                next.add(new WorldCoord(wc.x, wc.y, wc.z + 1));
                next.add(new WorldCoord(wc.x, wc.y, wc.z - 1));
                next.add(new WorldCoord(wc.x + 1, wc.y - 1, wc.z + 1));
                next.add(new WorldCoord(wc.x + 1, wc.y - 1, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y - 1, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y - 1, wc.z + 1));
                next.add(new WorldCoord(wc.x + 1, wc.y, wc.z + 1));
                next.add(new WorldCoord(wc.x + 1, wc.y, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y, wc.z + 1));
                next.add(new WorldCoord(wc.x + 1, wc.y + 1, wc.z + 1));
                next.add(new WorldCoord(wc.x + 1, wc.y + 1, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y + 1, wc.z - 1));
                next.add(new WorldCoord(wc.x - 1, wc.y + 1, wc.z + 1));
            }
        }
        return blocklist;
    }

    public static boolean checkAAB(World world, AxisAlignedBB bounds, int x, int y, int z) {
        if (bounds == null) {
            return true;
        }
        return world.func_72855_b(bounds.func_72325_c((double)x, (double)y, (double)z));
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer player, double blockReachDistance, boolean bool) {
        float f = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = blockReachDistance;
        if (d3 <= 0.0) {
            d3 = 5.0;
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static void setBiomeAt(World world, int x, int z, BiomeGenBase biome) {
        if (biome == null) {
            return;
        }
        Chunk chunk = world.func_72938_d(x, z);
        byte[] biomeArray = chunk.func_76605_m();
        biomeArray[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.field_76756_M & 0xFF);
        chunk.func_76616_a(biomeArray);
        if (Platform.isServer()) {
            PacketHandler.network.sendToAllAround((IMessage)new PacketBiomeChange.BiomeChangeMessage(x, z, (short)biome.field_76756_M), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)world.func_72825_h(x, z), (double)z, 32.0));
        }
    }

    public static boolean resetBiomeAt(World world, int x, int z) {
        BiomeGenBase[] defaultBiome = world.func_72959_q().func_76933_b(null, x, z, 1, 1);
        if (defaultBiome != null && defaultBiome[0] != null && world.func_72807_a(x, z) != defaultBiome[0]) {
            WorldUtil.setBiomeAt(world, x, z, defaultBiome[0]);
            return true;
        }
        return false;
    }

    public static void setBiomeAtChunk(World world, Chunk chunk, BiomeGenBase biome) {
        if (biome == null) {
            return;
        }
        byte[] biomeArray = chunk.func_76605_m();
        Arrays.fill(biomeArray, (byte)(biome.field_76756_M & 0xFF));
        chunk.func_76616_a(biomeArray);
    }

    private static List<WorldCoord> plotHelper(WorldCoord P1, WorldCoord P2, ForgeDirection side, float hitX, float hitY, float hitZ, int size) {
        ArrayList<WorldCoord> blocks = new ArrayList<WorldCoord>();
        int minmax = 0;
        if (size % 2 == 0) {
            minmax = size / 2;
            int X = hitX <= 0.5f ? -1 : 1;
            int Y = hitY <= 0.5f ? -1 : 1;
            int Z = hitZ <= 0.5f ? -1 : 1;
            switch (side) {
                case DOWN: 
                case UP: {
                    if (X > 0 && Z > 0) {
                        P1.add(minmax, 0, minmax);
                        P2.subtract(minmax - X, 0, minmax - Z);
                    }
                    if (Z > 0 && X < 0) {
                        P1.add(minmax + X, 0, minmax);
                        P2.subtract(minmax, 0, minmax - Z);
                    }
                    if (Z < 0 && X > 0) {
                        P1.add(minmax, 0, minmax + Z);
                        P2.subtract(minmax - X, 0, minmax);
                    }
                    if (X >= 0 || Z >= 0) break;
                    P1.add(minmax + X, 0, minmax + Z);
                    P2.subtract(minmax, 0, minmax);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (X > 0 && Y > 0) {
                        P1.add(minmax, minmax, 0);
                        P2.subtract(minmax - X, minmax - Y, 0);
                    }
                    if (Y > 0 && X < 0) {
                        P1.add(minmax + X, minmax, 0);
                        P2.subtract(minmax, minmax - Y, 0);
                    }
                    if (Y < 0 && X > 0) {
                        P1.add(minmax, minmax + Y, 0);
                        P2.subtract(minmax - X, minmax, 0);
                    }
                    if (X >= 0 || Y >= 0) break;
                    P1.add(minmax + X, minmax + Y, 0);
                    P2.subtract(minmax, minmax, 0);
                    break;
                }
                case EAST: 
                case WEST: {
                    if (Z > 0 && Y > 0) {
                        P1.add(0, minmax, minmax);
                        P2.subtract(0, minmax - Y, minmax - Z);
                    }
                    if (Y > 0 && Z < 0) {
                        P1.add(0, minmax, minmax + Z);
                        P2.subtract(0, minmax - Y, minmax);
                    }
                    if (Y < 0 && Z > 0) {
                        P1.add(0, minmax + Y, minmax);
                        P2.subtract(0, minmax, minmax - Z);
                    }
                    if (Z < 0 && Y < 0) {
                        P1.add(0, minmax + Y, minmax + Z);
                        P2.subtract(0, minmax, minmax);
                    }
                }
                case UNKNOWN: {
                    break;
                }
            }
        } else {
            minmax = (size - 1) / 2;
            switch (side) {
                case DOWN: 
                case UP: {
                    P1.add(minmax, 0, minmax);
                    P2.subtract(minmax, 0, minmax);
                    break;
                }
                case EAST: 
                case WEST: {
                    P1.add(0, minmax, minmax);
                    P2.subtract(0, minmax, minmax);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    P1.add(minmax, minmax, 0);
                    P2.subtract(minmax, minmax, 0);
                    break;
                }
            }
        }
        blocks.add(P1);
        blocks.add(P2);
        return blocks;
    }
}

