/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.asm;

import com.github.elenterius.magianaturalis.MagiaNaturalis;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    private static final String classToBeTransformed = "net.minecraft.client.renderer.entity.RendererLivingEntity";

    private static void transformRendererLivingEntity(ClassNode classNode, int isObfuscated) {
        String RENDER_MODEL = isObfuscated == 1 ? "a" : "renderModel";
        String RENDER_MODEL_DESC = isObfuscated == 1 ? "(Lsv;FFFFFF)V" : "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V";
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(RENDER_MODEL) || !method.desc.equals(RENDER_MODEL_DESC)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 1 || instruction.getNext().getOpcode() != 184) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode != null) {
                targetNode = targetNode.getNext().getNext();
                String DESC = isObfuscated == 1 ? "(Lsv;)Z" : "(Lnet/minecraft/entity/EntityLivingBase;)Z";
                MethodInsnNode newNode = new MethodInsnNode(184, "com/github/elenterius/magianaturalis/asm/MethodStub", "showInvisibleEntityToPlayer", DESC, false);
                method.instructions.set(targetNode.getPrevious(), (AbstractInsnNode)newNode);
                targetNode = targetNode.getNext();
                method.instructions.remove(targetNode.getPrevious());
                targetNode = targetNode.getNext();
                method.instructions.remove(targetNode.getPrevious());
                targetNode = targetNode.getNext();
                JumpInsnNode jumpNode = new JumpInsnNode(153, ((JumpInsnNode)targetNode.getPrevious()).label);
                method.instructions.set(targetNode.getPrevious(), (AbstractInsnNode)jumpNode);
                break;
            }
            MagiaNaturalis.LOGGER.info("can't find place for byte injection");
            break;
        }
    }

    public byte[] transform(String className, String transformedName, byte[] classfileBuffer) {
        int isObfuscated;
        int n = isObfuscated = !className.equals(transformedName) ? 1 : 0;
        if (!transformedName.equals(classToBeTransformed)) {
            return classfileBuffer;
        }
        MagiaNaturalis.LOGGER.info("Transforming: net.minecraft.client.renderer.entity.RendererLivingEntity");
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classfileBuffer);
            classReader.accept((ClassVisitor)classNode, 0);
            ClassTransformer.transformRendererLivingEntity(classNode, isObfuscated);
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            classfileBuffer = classWriter.toByteArray();
            MagiaNaturalis.LOGGER.info("Successfully transformed class: net.minecraft.client.renderer.entity.RendererLivingEntity");
        }
        catch (Exception e) {
            MagiaNaturalis.LOGGER.catching((Throwable)e);
        }
        return classfileBuffer;
    }
}

