/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.client.render;

import com.github.elenterius.magianaturalis.MagiaNaturalis;
import com.github.elenterius.magianaturalis.api.ISpectacles;
import com.github.elenterius.magianaturalis.block.chest.ArcaneChestBlockEntity;
import com.github.elenterius.magianaturalis.client.render.RenderUtil;
import com.github.elenterius.magianaturalis.item.artifact.DarkCrystalGogglesItem;
import com.github.elenterius.magianaturalis.item.focus.BuilderFocusItem;
import com.github.elenterius.magianaturalis.util.BuilderFocusUtil;
import com.github.elenterius.magianaturalis.util.Platform;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileNodeEnergized;
import thaumcraft.common.tiles.TileOwned;

@SideOnly(value=Side.CLIENT)
public final class RenderEventHandler {
    private static final ResourceLocation SILKTOUCH_TEXTURE = new ResourceLocation("thaumcraft", "textures/foci/silktouch.png");
    private static final ResourceLocation GLOWING_EYES_TEXTURE = MagiaNaturalis.rl("textures/models/glowingEyes.png");
    private static final ModelBiped OVERLAY_MODEL = new ModelBiped();
    private final RenderItem itemRender = new RenderItem();
    private ItemStack prevPickedBlock = null;
    private int prevCount = 0;

    private RenderEventHandler() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (Minecraft.func_71382_s() && !mc.func_147113_T() && !mc.field_71474_y.field_74330_P && mc.field_71451_h instanceof EntityPlayer) {
            ItemWandCasting wand;
            ItemFocusBasic focus;
            EntityPlayer player = (EntityPlayer)mc.field_71451_h;
            ItemStack stack = player.field_71071_by.func_70440_f(3);
            if (stack != null && stack.func_77973_b() instanceof ISpectacles && ((ISpectacles)stack.func_77973_b()).drawSpectacleHUD(stack, (EntityLivingBase)player)) {
                this.renderSpectaclesHUD(mc, player);
            }
            if ((stack = player.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemWandCasting && (focus = (wand = (ItemWandCasting)stack.func_77973_b()).getFocus(stack)) instanceof BuilderFocusItem) {
                ItemStack focusStack = wand.getFocusItem(stack);
                this.renderBuildFocusHUD(mc, focusStack, player);
            }
        }
    }

    @SubscribeEvent
    public void renderPlayerSpecial(RenderPlayerEvent.Specials.Pre event) {
        if (!event.renderHelmet) {
            return;
        }
        ItemStack itemStack = event.entityPlayer.field_71071_by.func_70440_f(3);
        if (itemStack != null && itemStack.func_77973_b() instanceof DarkCrystalGogglesItem) {
            GL11.glPushMatrix();
            float scale = 0.0625f;
            event.renderer.field_77109_a.field_78116_c.func_78794_c(scale);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GLOWING_EYES_TEXTURE);
            GL11.glTranslatef((float)0.0f, (float)scale, (float)-0.01f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glDepthMask((!event.entityPlayer.func_82150_aj() ? 1 : 0) != 0);
            int c0 = 61680;
            int j = c0 % 65536;
            int k = c0 / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderEventHandler.OVERLAY_MODEL.field_78116_c.func_78785_a(scale);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    private void renderBuildFocusHUD(Minecraft mc, ItemStack focusStack, EntityPlayer player) {
        GL11.glClear((int)256);
        FontRenderer fontRenderer = mc.field_71466_p;
        BuilderFocusUtil.Mode builderMode = BuilderFocusUtil.getMode(focusStack);
        Block pblock = null;
        int pbdata = 0;
        Item item = null;
        ItemStack pickedBlock = null;
        if (builderMode == BuilderFocusUtil.Mode.UNIFORM) {
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                pblock = player.field_70170_p.func_147439_a(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
                pbdata = player.field_70170_p.func_72805_g(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
                item = Item.func_150898_a((Block)pblock);
            }
            if (item != null) {
                if (pblock == Blocks.field_150398_cm) {
                    pbdata = pblock.func_149643_k(player.field_70170_p, mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
                }
                pickedBlock = new ItemStack(item, 1, pbdata);
            }
            if (pickedBlock == null && pblock != null) {
                pickedBlock = pblock == Blocks.field_150439_ay ? new ItemStack(Blocks.field_150450_ax) : pblock.getPickBlock(mc.field_71476_x, player.field_70170_p, mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            }
        } else {
            int[] i = BuilderFocusUtil.getPickedBlock(focusStack);
            pblock = Block.func_149729_e((int)i[0]);
            pbdata = i[1];
            if (pblock != Blocks.field_150350_a && pblock != null) {
                item = Item.func_150898_a((Block)pblock);
                pickedBlock = new ItemStack(item, 1, pbdata);
            }
        }
        if (pickedBlock != null) {
            int amount = this.prevCount;
            if (!(player.field_71075_bZ.field_75098_d || !player.field_71071_by.field_70459_e && pickedBlock == this.prevPickedBlock && pickedBlock.func_77969_a(this.prevPickedBlock))) {
                amount = this.countItemsInInventory(player, pickedBlock);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)49.0f, (float)44.0f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            RenderUtil.drawItemStack(this.itemRender, fontRenderer, pickedBlock, 0, 0);
            GL11.glEnable((int)3042);
            GL11.glTranslatef((float)0.0f, (float)(-fontRenderer.field_78288_b), (float)500.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            if (player.field_71075_bZ.field_75098_d) {
                RenderUtil.drawStringWithBorder(fontRenderer, "Infinite", 0, 48, 0xFFFFFF, 0);
            } else {
                RenderUtil.drawStringWithBorder(fontRenderer, "" + amount, 0, 48, 0xFFFFFF, 0);
            }
            RenderUtil.drawStringWithBorder(fontRenderer, "Shape: " + (Object)((Object)BuilderFocusUtil.getShape(focusStack)), 0, -2, 0xFFFFFF, 0);
            RenderUtil.drawStringWithBorder(fontRenderer, "Size: " + BuilderFocusUtil.getSize(focusStack), 0, -1 + fontRenderer.field_78288_b, 0xFFFFFF, 0);
            if (builderMode == BuilderFocusUtil.Mode.UNIFORM) {
                GL11.glPushMatrix();
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                GL11.glTranslatef((float)15.0f, (float)15.0f, (float)0.0f);
                RenderUtil.drawTextureQuad(SILKTOUCH_TEXTURE, 16.0f, 16.0f);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            this.prevCount = amount;
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)49.0f, (float)44.0f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glTranslatef((float)0.0f, (float)(-fontRenderer.field_78288_b), (float)500.0f);
            RenderUtil.drawStringWithBorder(fontRenderer, "?", 6, 14, 0xFFFFFF, 0);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            RenderUtil.drawStringWithBorder(fontRenderer, "Shape: " + (Object)((Object)BuilderFocusUtil.getShape(focusStack)), 0, -2, 0xFFFFFF, 0);
            RenderUtil.drawStringWithBorder(fontRenderer, "Size: " + BuilderFocusUtil.getSize(focusStack), 0, -1 + fontRenderer.field_78288_b, 0xFFFFFF, 0);
            if (builderMode == BuilderFocusUtil.Mode.UNIFORM) {
                GL11.glPushMatrix();
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                GL11.glTranslatef((float)15.0f, (float)15.0f, (float)0.0f);
                RenderUtil.drawTextureQuad(SILKTOUCH_TEXTURE, 16.0f, 16.0f);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            this.prevCount = 0;
        }
        this.prevPickedBlock = pickedBlock;
    }

    private int countItemsInInventory(EntityPlayer player, ItemStack itemStack) {
        int amount = 0;
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is == null || !is.func_77969_a(itemStack)) continue;
            amount += is.field_77994_a;
        }
        player.field_71071_by.field_70459_e = false;
        return amount;
    }

    private void renderSpectaclesHUD(Minecraft mc, EntityPlayer player) {
        boolean meterEquiped = false;
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == ConfigItems.itemThaumometer) {
            meterEquiped = true;
        }
        if (mc.field_71474_y.field_74320_O == 0 && mc.field_71462_r == null && !meterEquiped) {
            TileEntity tile = null;
            MovingObjectPosition mop = mc.field_71476_x;
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                tile = player.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            }
            FontRenderer fontRenderer = mc.field_71466_p;
            if (tile != null) {
                ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                int w = scaledresolution.func_78326_a();
                int h = scaledresolution.func_78328_b();
                if (tile instanceof INode) {
                    INode node = (INode)tile;
                    String meta = Platform.translate("nodetype." + node.getNodeType() + ".name");
                    if (node.getNodeModifier() != null) {
                        meta = meta + ", " + Platform.translate("nodemod." + node.getNodeModifier() + ".name");
                    }
                    String name = Platform.translate("table.blockAiry.0.name");
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(name, -fontRenderer.func_78256_a(name) / 2, 25, 15751100);
                    fontRenderer.func_78261_a(meta, -fontRenderer.func_78256_a(meta) / 2, 35, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof TileNodeEnergized) {
                    TileNodeEnergized nodeEnergized = (TileNodeEnergized)tile;
                    String meta = Platform.translate("nodetype." + nodeEnergized.getNodeType() + ".name");
                    if (nodeEnergized.getNodeModifier() != null) {
                        meta = meta + ", " + Platform.translate("nodemod." + nodeEnergized.getNodeModifier() + ".name");
                    }
                    String name = Platform.translate("table.blockAiry.5.name");
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(name, -fontRenderer.func_78256_a(name) / 2, 25, 15751100);
                    fontRenderer.func_78261_a(meta, -fontRenderer.func_78256_a(meta) / 2, 35, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof TileOwned) {
                    TileOwned owned = (TileOwned)tile;
                    String owner = EnumChatFormatting.DARK_PURPLE + "Owner" + EnumChatFormatting.RESET + " " + owned.owner;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(owner, -(fontRenderer.func_78256_a(owner) - 4) / 2, 25, 0xFFFFFF);
                    GL11.glPopMatrix();
                } else if (tile instanceof ArcaneChestBlockEntity) {
                    ArcaneChestBlockEntity chest = (ArcaneChestBlockEntity)tile;
                    String name = EnumChatFormatting.DARK_PURPLE + "Owner" + EnumChatFormatting.RESET + " " + chest.getOwnerName();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(w / 2), (float)(h / 2), (float)0.0f);
                    fontRenderer.func_78261_a(name, -(fontRenderer.func_78256_a(name) - 4) / 2, 25, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
            }
        }
    }
}

