/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.init.client;

import com.github.elenterius.magianaturalis.block.banner.CustomBannerBlockEntity;
import com.github.elenterius.magianaturalis.block.chest.ArcaneChestBlockEntity;
import com.github.elenterius.magianaturalis.block.geopylon.GeoPylonBlockEntity;
import com.github.elenterius.magianaturalis.block.jar.PrisonJarBlockEntity;
import com.github.elenterius.magianaturalis.block.table.TranscribingTableBlockEntity;
import com.github.elenterius.magianaturalis.client.gui.GuiArcaneChest;
import com.github.elenterius.magianaturalis.client.gui.GuiEvilTrunk;
import com.github.elenterius.magianaturalis.client.gui.GuiTranscribingTable;
import com.github.elenterius.magianaturalis.client.render.RenderEventHandler;
import com.github.elenterius.magianaturalis.client.render.block.BlockEntityRenderer;
import com.github.elenterius.magianaturalis.client.render.block.BlockJarRenderer;
import com.github.elenterius.magianaturalis.client.render.entity.breeder.TaintBreederRenderer;
import com.github.elenterius.magianaturalis.client.render.entity.trunk.EvilTrunkRenderer;
import com.github.elenterius.magianaturalis.client.render.item.RenderItemEvilTrunkSpawner;
import com.github.elenterius.magianaturalis.client.render.tile.TileArcaneChestRenderer;
import com.github.elenterius.magianaturalis.client.render.tile.TileBannerCustomRenderer;
import com.github.elenterius.magianaturalis.client.render.tile.TileGeoMorpherRenderer;
import com.github.elenterius.magianaturalis.client.render.tile.TileJarPrisonRenderer;
import com.github.elenterius.magianaturalis.client.render.tile.TileTranscribingTableRenderer;
import com.github.elenterius.magianaturalis.entity.EntityEvilTrunk;
import com.github.elenterius.magianaturalis.entity.EntityZombieExtended;
import com.github.elenterius.magianaturalis.entity.taint.EntityTaintBreeder;
import com.github.elenterius.magianaturalis.init.CommonSetup;
import com.github.elenterius.magianaturalis.init.MNItems;
import com.github.elenterius.magianaturalis.init.client.KeyEventHandler;
import com.github.elenterius.magianaturalis.init.client.MNKeyBindings;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderZombie;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientSetup
extends CommonSetup {
    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerRenderer();
        RenderEventHandler.register();
        MNKeyBindings.register();
        KeyEventHandler.register();
    }

    public void registerRenderer() {
        this.registerBlockRenderer(new BlockEntityRenderer());
        this.registerTileEntitySpecialRenderer(TranscribingTableBlockEntity.class, new TileTranscribingTableRenderer());
        this.registerTileEntitySpecialRenderer(ArcaneChestBlockEntity.class, new TileArcaneChestRenderer());
        this.registerTileEntitySpecialRenderer(CustomBannerBlockEntity.class, new TileBannerCustomRenderer());
        this.registerBlockRenderer(new BlockJarRenderer());
        this.registerTileEntitySpecialRenderer(PrisonJarBlockEntity.class, new TileJarPrisonRenderer());
        this.registerTileEntitySpecialRenderer(GeoPylonBlockEntity.class, new TileGeoMorpherRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MNItems.evilTrunkSpawner, (IItemRenderer)new RenderItemEvilTrunkSpawner());
        RenderingRegistry.registerEntityRenderingHandler(EntityTaintBreeder.class, (Render)new TaintBreederRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvilTrunk.class, (Render)new EvilTrunkRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityZombieExtended.class, (Render)new RenderZombie());
    }

    public void registerTileEntitySpecialRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)renderer);
    }

    public void registerBlockRenderer(ISimpleBlockRenderingHandler renderer) {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 1: {
                return new GuiTranscribingTable(player.field_71071_by, (TranscribingTableBlockEntity)world.func_147438_o(x, y, z));
            }
            case 2: {
                return new GuiArcaneChest(player.field_71071_by, (ArcaneChestBlockEntity)world.func_147438_o(x, y, z));
            }
            case 3: {
                return new GuiEvilTrunk(player, (EntityEvilTrunk)world.func_73045_a(x));
            }
        }
        return null;
    }
}

