/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.item.artifact;

import com.github.elenterius.magianaturalis.MagiaNaturalis;
import com.github.elenterius.magianaturalis.util.NBTUtil;
import com.github.elenterius.magianaturalis.util.Platform;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketAspectPool;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.TileDeconstructionTable;

public class ResearchLogItem
extends Item {
    public ResearchLogItem() {
        this.field_77777_bU = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (GuiScreen.func_146271_m()) {
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.AIR), EnumChatFormatting.YELLOW, Aspect.AIR.getName()));
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.EARTH), EnumChatFormatting.GREEN, Aspect.EARTH.getName()));
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.WATER), EnumChatFormatting.AQUA, Aspect.WATER.getName()));
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.FIRE), EnumChatFormatting.RED, Aspect.FIRE.getName()));
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.ORDER), EnumChatFormatting.WHITE, Aspect.ORDER.getName()));
            list.add(String.format("%dx %s%s", this.getResearchPoint(stack, Aspect.ENTROPY), EnumChatFormatting.DARK_GRAY, Aspect.ENTROPY.getName()));
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + Platform.translate("hint.magianaturalis.ctrl"));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        Aspect[] array;
        if (stack == null) {
            return null;
        }
        if (Platform.isClient()) {
            return stack;
        }
        if (player.func_70093_af()) {
            return stack;
        }
        for (Aspect aspect : array = new Aspect[]{Aspect.AIR, Aspect.EARTH, Aspect.WATER, Aspect.FIRE, Aspect.ORDER, Aspect.ENTROPY}) {
            short amount = NBTUtil.getOrCreate(stack).func_74765_d("rp:" + aspect.getTag());
            if (amount <= 0 || !MagiaNaturalis.proxyTC4.playerKnowledge.addAspectPool(player.func_70005_c_(), aspect, amount)) continue;
            ResearchManager.scheduleSave((EntityPlayer)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketAspectPool(aspect.getTag(), Short.valueOf(amount), Short.valueOf(Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(player.func_70005_c_(), aspect))), (EntityPlayerMP)player);
            this.setResearchPoint(stack, aspect, (short)0);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (Platform.isClient()) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDeconstructionTable) {
            TileDeconstructionTable table = (TileDeconstructionTable)tile;
            boolean bool = this.addResearchPoint(stack, table.aspect, (short)1);
            if (bool) {
                table.aspect = null;
                world.func_147471_g(x, y, z);
            }
            return bool;
        }
        return false;
    }

    public short getResearchPoint(ItemStack stack, Aspect aspect) {
        if (stack != null && aspect != null) {
            return NBTUtil.getOrCreate(stack).func_74765_d("rp:" + aspect.getTag());
        }
        return 0;
    }

    public boolean setResearchPoint(ItemStack stack, Aspect aspect, short size) {
        if (stack != null && aspect != null) {
            if (size > 64) {
                return false;
            }
            if (size < 0) {
                size = 0;
            }
            NBTUtil.getOrCreate(stack).func_74777_a("rp:" + aspect.getTag(), size);
            return true;
        }
        return false;
    }

    public boolean addResearchPoint(ItemStack stack, Aspect aspect, short size) {
        if (stack != null && aspect != null && size > 0) {
            if ((size = (short)(size + NBTUtil.getOrCreate(stack).func_74765_d("rp:" + aspect.getTag()))) > 64) {
                return false;
            }
            NBTUtil.getOrCreate(stack).func_74777_a("rp:" + aspect.getTag(), size);
            return true;
        }
        return false;
    }
}

