/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.item.artifact;

import com.github.elenterius.magianaturalis.util.BlockUtil;
import com.github.elenterius.magianaturalis.util.Platform;
import com.github.elenterius.magianaturalis.util.WorldCoord;
import com.github.elenterius.magianaturalis.util.WorldUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class SickleItem
extends Item {
    private static final Block[] isEffective = new Block[]{Blocks.field_150321_G, Blocks.field_150329_H, Blocks.field_150395_bd, Blocks.field_150473_bD, Blocks.field_150488_af};
    protected Item.ToolMaterial theToolMaterial;
    protected float efficiencyOnProperMaterial = 8.0f;
    protected int abundanceLevel = 0;
    protected int areaSize = 0;
    protected int colorLoot = 3;
    protected boolean collectLoot = false;
    protected final float attackDamage;

    public SickleItem(Item.ToolMaterial material) {
        this.theToolMaterial = material;
        this.efficiencyOnProperMaterial += material.func_77998_b();
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.attackDamage = 3.0f + material.func_78000_c();
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G || block == Blocks.field_150488_af || block == Blocks.field_150473_bD;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return block != Blocks.field_150321_G && block.func_149688_o() != Material.field_151584_j && !(block instanceof IPlantable) ? (block == Blocks.field_150325_L ? this.efficiencyOnProperMaterial - 10.0f : 1.0f) : this.efficiencyOnProperMaterial;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (Platform.isClient()) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
                for (int i = 0; i < this.abundanceLevel; ++i) {
                    drops.addAll(target.onSheared(stack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack)));
                }
                Random rand = new Random();
                for (ItemStack drop : drops) {
                    EntityItem ent = entity.func_70099_a(drop, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                stack.func_77972_a(1, entity);
            }
            return true;
        }
        return false;
    }

    private boolean isEffectiveVsBlock(Block block) {
        if (block.func_149688_o() == Material.field_151584_j || block instanceof IShearable || block instanceof IPlantable || block instanceof IGrowable && !(block instanceof BlockGrass)) {
            return true;
        }
        for (int index = 0; index < isEffective.length; ++index) {
            if (isEffective[index] != block) continue;
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (!this.isEffectiveVsBlock(block)) {
            stack.func_77972_a(1, entity);
            return false;
        }
        if (entity.func_70093_af()) {
            boolean success = false;
            if (world.func_72962_a((EntityPlayer)entity, x, y, z) && (success = BlockUtil.harvestBlock(world, (EntityPlayer)entity, x, y, z, this.collectLoot, this.abundanceLevel, this.colorLoot))) {
                stack.func_77972_a(1, entity);
            }
            return success;
        }
        if (Platform.isServer() && entity instanceof EntityPlayer) {
            List<WorldCoord> blocks = WorldUtil.plotVeinArea((EntityPlayer)entity, world, x, y, z, this.areaSize);
            boolean success = false;
            for (WorldCoord coord : blocks) {
                Block tempBlock;
                if (stack.func_77960_j() > stack.func_77958_k() - this.abundanceLevel) break;
                if (!world.func_72962_a((EntityPlayer)entity, coord.x, coord.y, coord.z) || !((tempBlock = world.func_147439_a(coord.x, coord.y, coord.z)).func_149712_f(world, coord.x, coord.y, coord.z) >= 0.0f) || !this.isEffectiveVsBlock(tempBlock) || !(success = BlockUtil.harvestBlock(world, (EntityPlayer)entity, coord.x, coord.y, coord.z, this.collectLoot, this.abundanceLevel, this.colorLoot))) continue;
                stack.func_77972_a(1, entity);
            }
            return success;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public String getToolMaterialName() {
        return this.theToolMaterial.toString();
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, 0));
        return multimap;
    }
}

