/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.util;

import com.github.elenterius.magianaturalis.util.NBTUtil;
import com.github.elenterius.magianaturalis.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class BuilderFocusUtil {
    public static final String MOD_TAG_KEY = "magianaturalis";
    public static final String MODE_TAG_KEY = "mode";
    public static final String SHAPE_TAG_KEY = "shape";
    public static final String SIZE_TAG_KEY = "size";

    public static Mode getMode(ItemStack stack) {
        if (stack == null) {
            return Mode.NONE;
        }
        NBTTagList list = NBTUtil.getOrCreate(stack).func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            return Mode.NONE;
        }
        return Mode.parseId(list.func_150305_b(0).func_74771_c(MODE_TAG_KEY));
    }

    public static boolean setMode(ItemStack stack, Mode mode) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.getOrCreate(stack);
        NBTTagList list = data.func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            list = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = list.func_150305_b(0);
        }
        tempData.func_74774_a(MODE_TAG_KEY, mode.id());
        list.func_74742_a((NBTBase)tempData);
        if (list.func_74745_c() > 0) {
            data.func_74782_a(MOD_TAG_KEY, (NBTBase)list);
            return true;
        }
        return false;
    }

    public static Shape getShape(ItemStack stack) {
        if (stack == null) {
            return Shape.NONE;
        }
        NBTTagList list = NBTUtil.getOrCreate(stack).func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            return Shape.NONE;
        }
        return Shape.parseId(list.func_150305_b(0).func_74771_c(SHAPE_TAG_KEY));
    }

    public static boolean setShape(ItemStack stack, Shape shape) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.getOrCreate(stack);
        NBTTagList list = data.func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            list = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = list.func_150305_b(0);
        }
        tempData.func_74774_a(SHAPE_TAG_KEY, shape.id());
        list.func_74742_a((NBTBase)tempData);
        if (list.func_74745_c() > 0) {
            stack.func_77983_a(MOD_TAG_KEY, (NBTBase)list);
            return true;
        }
        return false;
    }

    public static int getSize(ItemStack stack) {
        if (stack == null) {
            return 1;
        }
        NBTTagList list = NBTUtil.getOrCreate(stack).func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            return 1;
        }
        return list.func_150305_b(0).func_74771_c(SIZE_TAG_KEY);
    }

    public static boolean setSize(ItemStack stack, int size) {
        NBTTagCompound tempData;
        if (stack == null) {
            return false;
        }
        NBTTagCompound data = NBTUtil.getOrCreate(stack);
        NBTTagList list = data.func_150295_c(MOD_TAG_KEY, 10);
        if (list == null) {
            list = new NBTTagList();
            tempData = new NBTTagCompound();
        } else {
            tempData = list.func_150305_b(0);
        }
        tempData.func_74774_a(SIZE_TAG_KEY, (byte)size);
        list.func_74742_a((NBTBase)tempData);
        if (list.func_74745_c() > 0) {
            stack.func_77983_a(MOD_TAG_KEY, (NBTBase)list);
            return true;
        }
        return false;
    }

    public static boolean cycleSize(ItemStack stack, int amount, int minSize, int maxSize) {
        int size = BuilderFocusUtil.getSize(stack) + amount;
        if (size > maxSize) {
            return BuilderFocusUtil.setSize(stack, minSize);
        }
        if (size < minSize) {
            return BuilderFocusUtil.setSize(stack, maxSize);
        }
        return BuilderFocusUtil.setSize(stack, size);
    }

    public static boolean setPickedBlock(ItemStack stack, Block block, int metadata) {
        NBTTagCompound nbttagcompound;
        NBTTagCompound data;
        NBTTagList nbttaglist;
        if (stack == null) {
            return false;
        }
        int bid = Block.func_149682_b((Block)block);
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((nbttaglist = (data = NBTUtil.getOrCreate(stack)).func_150295_c(MOD_TAG_KEY, 10)) == null) {
            nbttaglist = new NBTTagList();
            nbttagcompound = new NBTTagCompound();
        } else {
            nbttagcompound = nbttaglist.func_150305_b(0);
        }
        nbttagcompound.func_74768_a("bid", bid);
        nbttagcompound.func_74774_a("bdata", (byte)metadata);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a(MOD_TAG_KEY, (NBTBase)nbttaglist);
            return true;
        }
        return false;
    }

    public static int[] getPickedBlock(ItemStack stack) {
        int[] i = new int[]{0, 0};
        if (stack == null) {
            return i;
        }
        NBTTagList nbttaglist = NBTUtil.getOrCreate(stack).func_150295_c(MOD_TAG_KEY, 10);
        if (nbttaglist == null) {
            return i;
        }
        i[0] = nbttaglist.func_150305_b(0).func_74762_e("bid");
        i[1] = nbttaglist.func_150305_b(0).func_74771_c("bdata");
        return i;
    }

    public static enum Shape {
        NONE,
        PLANE,
        CUBE,
        PLANE_EXTEND,
        SPHERE;


        public static Shape parseId(int i) {
            if (i < 0 || i >= Shape.values().length) {
                return NONE;
            }
            return Shape.values()[i];
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public Shape next() {
            int id = this.ordinal() + 1;
            if (id >= Shape.values().length) {
                return Shape.values()[1];
            }
            return Shape.values()[id];
        }

        public Shape prev() {
            int id = this.ordinal() - 1;
            if (id <= 1) {
                return Shape.values()[Shape.values().length - 1];
            }
            return Shape.values()[id];
        }

        public String toString() {
            switch (this) {
                case CUBE: {
                    return Platform.translate("enum.magianaturalis.shape.cube");
                }
                case NONE: {
                    return Platform.translate("enum.magianaturalis.none");
                }
                case PLANE: {
                    return Platform.translate("enum.magianaturalis.shape.plane");
                }
                case PLANE_EXTEND: {
                    return Platform.translate("enum.magianaturalis.shape.plane.extend");
                }
                case SPHERE: {
                    return Platform.translate("enum.magianaturalis.shape.sphere");
                }
            }
            return Platform.translate("enum.magianaturalis.unknown");
        }
    }

    public static enum Mode {
        NONE,
        UNIFORM;


        public static Mode parseId(int i) {
            if (i < 0 || i >= Mode.values().length) {
                return NONE;
            }
            return Mode.values()[i];
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public Mode cycle() {
            return this == NONE ? UNIFORM : NONE;
        }

        public String toString() {
            switch (this) {
                case NONE: {
                    return Platform.translate("enum.magianaturalis.none");
                }
                case UNIFORM: {
                    return Platform.translate("enum.magianaturalis.mode.uniform");
                }
            }
            return Platform.translate("enum.magianaturalis.unknown");
        }
    }
}

