/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.util;

import com.github.elenterius.magianaturalis.util.access.UserAccess;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public final class NBTUtil {
    public static NBTTagCompound getOrCreate(ItemStack stack) {
        NBTTagCompound data = stack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
            stack.func_77982_d(data);
        }
        return data;
    }

    public static NBTTagList newDoubleNBTList(double[] values) {
        NBTTagList list = new NBTTagList();
        for (double v : values) {
            list.func_74742_a((NBTBase)new NBTTagDouble(v));
        }
        return list;
    }

    public static void saveInventoryToNBT(ItemStack stack, ItemStack[] inventory) {
        NBTUtil.saveInventoryToNBT(NBTUtil.getOrCreate(stack), inventory);
    }

    public static void saveInventoryToNBT(NBTTagCompound data, ItemStack[] inventory) {
        if (inventory == null) {
            return;
        }
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < inventory.length; ++i) {
            NBTTagCompound tempData = new NBTTagCompound();
            tempData.func_74774_a("Slot", (byte)i);
            if (inventory[i] != null) {
                inventory[i].func_77955_b(tempData);
            }
            items.func_74742_a((NBTBase)tempData);
        }
        data.func_74782_a("Items", (NBTBase)items);
    }

    public static ArrayList<ItemStack> loadInventoryFromNBT(ItemStack stack) {
        NBTTagCompound data = NBTUtil.getOrCreate(stack);
        if (!data.func_74764_b("Items")) {
            return null;
        }
        NBTTagList items = data.func_150295_c("Items", 10);
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound tempData = items.func_150305_b(i);
            byte j = tempData.func_74771_c("Slot");
            if (j < 0) continue;
            inventory.add(ItemStack.func_77949_a((NBTTagCompound)tempData));
        }
        return inventory;
    }

    public static ItemStack[] loadInventoryFromNBT(ItemStack stack, int invSize) {
        return NBTUtil.loadInventoryFromNBT(NBTUtil.getOrCreate(stack), invSize);
    }

    public static ItemStack[] loadInventoryFromNBT(NBTTagCompound data, int invSize) {
        if (!data.func_74764_b("Items")) {
            return null;
        }
        NBTTagList items = data.func_150295_c("Items", 10);
        ItemStack[] inventory = new ItemStack[invSize];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound tempData = items.func_150305_b(i);
            byte j = tempData.func_74771_c("Slot");
            if (j < 0) continue;
            inventory[i] = ItemStack.func_77949_a((NBTTagCompound)tempData);
        }
        return inventory;
    }

    public static void saveUserAccessToNBT(ItemStack stack, ArrayList<UserAccess> users) {
        NBTUtil.saveUserAccessToNBT(NBTUtil.getOrCreate(stack), users);
    }

    public static ArrayList<UserAccess> loadUserAccessFromNBT(ItemStack stack) {
        return NBTUtil.loadUserAccessFromNBT(NBTUtil.getOrCreate(stack));
    }

    public static void saveUserAccessToNBT(NBTTagCompound data, ArrayList<UserAccess> users) {
        if (users == null) {
            return;
        }
        NBTTagList accessList = new NBTTagList();
        for (UserAccess user : users) {
            NBTTagCompound tempData = new NBTTagCompound();
            tempData.func_74778_a("UUID", user.getUUID().toString());
            tempData.func_74774_a("Type", user.getAccessLevel());
            accessList.func_74742_a((NBTBase)tempData);
        }
        data.func_74782_a("AccessList", (NBTBase)accessList);
    }

    public static ArrayList<UserAccess> loadUserAccessFromNBT(NBTTagCompound data) {
        if (!data.func_74764_b("AccessList")) {
            return new ArrayList<UserAccess>();
        }
        NBTTagList tagList = data.func_150295_c("AccessList", 10);
        ArrayList<UserAccess> accessList = new ArrayList<UserAccess>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tempData = tagList.func_150305_b(i);
            UserAccess user = new UserAccess();
            user.setUUID(UUID.fromString(tempData.func_74779_i("UUID")));
            user.setAccesLevel(tempData.func_74771_c("Type"));
            accessList.add(user);
        }
        return accessList;
    }

    public static boolean spawnEntityFromNBT(NBTTagCompound data, World world, double x, double y, double z) {
        if (world == null) {
            return false;
        }
        if (data == null || !data.func_74764_b("id")) {
            return false;
        }
        data.func_74782_a("Pos", (NBTBase)NBTUtil.newDoubleNBTList(new double[]{x, y, z}));
        data.func_74782_a("Motion", (NBTBase)NBTUtil.newDoubleNBTList(new double[]{0.0, 0.0, 0.0}));
        data.func_74776_a("FallDistance", 0.0f);
        data.func_74768_a("Dimension", world.field_73011_w.field_76574_g);
        Entity entity = EntityList.func_75615_a((NBTTagCompound)data, (World)world);
        if (entity == null) {
            return false;
        }
        return world.func_72838_d(entity);
    }
}

