/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.magianaturalis.util.access;

import com.github.elenterius.magianaturalis.block.chest.ArcaneChestBlockEntity;
import com.github.elenterius.magianaturalis.init.MNBlocks;
import com.github.elenterius.magianaturalis.util.Platform;
import com.github.elenterius.magianaturalis.util.access.UserAccess;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.blocks.BlockArcaneDoor;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileOwned;

public final class UserAccessUtil {
    private UserAccessUtil() {
    }

    public static byte addPlayerToAccessList(GameProfile gameProfile, byte accesLevel, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 0;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (block == MNBlocks.arcaneChest) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null) {
                return 0;
            }
            if (tile instanceof ArcaneChestBlockEntity) {
                ArcaneChestBlockEntity chest = (ArcaneChestBlockEntity)tile;
                if (!(chest.owner.equals(gameProfile.getId()) || chest.accessList.contains(new UserAccess(gameProfile.getId(), 1)) || chest.accessList.contains(new UserAccess(gameProfile.getId(), 2)) || chest.accessList.contains(new UserAccess(gameProfile.getId(), 0)))) {
                    chest.accessList.add(new UserAccess(gameProfile.getId(), accesLevel));
                    world.func_147471_g(x, y, z);
                    return 1;
                }
            }
        } else {
            if (block == ConfigBlocks.blockArcaneDoor) {
                TileEntity[] tiles = new TileEntity[2];
                tiles[0] = world.func_147438_o(x, y, z);
                int offset = 1;
                int magic = ((BlockArcaneDoor)block).getFullMetadata((IBlockAccess)world, x, y, z);
                if ((magic & 8) != 0) {
                    offset = -1;
                }
                tiles[1] = world.func_147438_o(x, y + offset, z);
                for (int b = 0; b < 2; b = (int)((byte)(b + 1))) {
                    if (tiles[b] == null || !(tiles[b] instanceof TileOwned)) continue;
                    TileOwned owned = (TileOwned)tiles[b];
                    if (owned.owner.equals(gameProfile.getName()) || owned.accessList.contains("0" + gameProfile.getName()) || owned.accessList.contains("1" + gameProfile.getName())) continue;
                    switch (accesLevel) {
                        case 2: {
                            accesLevel = 1;
                            break;
                        }
                        case 1: {
                            accesLevel = 0;
                        }
                    }
                    owned.accessList.add(accesLevel + gameProfile.getName());
                }
                world.func_147471_g(x, y, z);
                world.func_147471_g(x, y + offset, z);
                return 2;
            }
            if (block == ConfigBlocks.blockWoodenDevice && (metadata == 2 || metadata == 3) || block != ConfigBlocks.blockWoodenDevice) {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile == null) {
                    return -1;
                }
                if (tile instanceof TileOwned) {
                    TileOwned owned = (TileOwned)tile;
                    if (!(owned.owner.equals(gameProfile.getName()) || owned.accessList.contains("0" + gameProfile.getName()) || owned.accessList.contains("1" + gameProfile.getName()))) {
                        switch (accesLevel) {
                            case 2: {
                                accesLevel = 1;
                                break;
                            }
                            case 1: {
                                accesLevel = 0;
                            }
                        }
                        owned.accessList.add(accesLevel + gameProfile.getName());
                        world.func_147471_g(x, y, z);
                        return 3;
                    }
                }
            }
        }
        return 0;
    }

    public static boolean addPlayerToAccessList(EntityPlayer player, byte accessLevel, World world, int x, int y, int z) {
        byte result;
        byte by = result = UserAccessUtil.addPlayerToAccessList(player.func_146103_bH(), accessLevel, world, x, y, z);
        result = (byte)(result - 1);
        if (by > 0) {
            world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:key", 1.0f, 0.9f);
            String[] word = new String[]{"chest", "door", "misc"};
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + Platform.translate("chat.magianaturalis.key.access." + word[result])));
            return true;
        }
        return false;
    }
}

