/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.api_impl;

import io.github.dennisochulor.tickrate.api.TickRateAPI;
import io.github.dennisochulor.tickrate.api.TickRateEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;

public final class TickRateAPIImpl
implements TickRateAPI {
    private static TickRateAPI INSTANCE;
    private final MinecraftServer server;
    private final class_8915 tickManager;

    public static TickRateAPI getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("The MinecraftServer must be fully initialised first before using the TickRateAPI!");
        }
        return INSTANCE;
    }

    public static void init(MinecraftServer server) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Only one instance can be present at any given time!");
        }
        INSTANCE = new TickRateAPIImpl(server);
    }

    public static void uninit() {
        INSTANCE = null;
    }

    private TickRateAPIImpl(MinecraftServer server) {
        this.server = server;
        this.tickManager = this.server.method_54833();
    }

    private void entityCheck(Collection<? extends class_1297> entities) throws IllegalArgumentException {
        Objects.requireNonNull(entities, "entities cannot be null!");
        entities.forEach(entity -> {
            if (entity.method_31481()) {
                throw new IllegalArgumentException("Entity must not be removed!");
            }
        });
    }

    private List<class_2818> chunkCheck(class_1937 level, Collection<class_1923> chunks) throws IllegalArgumentException {
        ArrayList<class_2818> levelChunks = new ArrayList<class_2818>();
        Objects.requireNonNull(level, "level cannot be null!");
        Objects.requireNonNull(chunks, "chunks cannot be null!");
        chunks.forEach(chunkPos -> {
            class_2818 levelChunk = (class_2818)level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
            if (levelChunk == null || levelChunk.method_12225() == class_3194.field_19334) {
                throw new IllegalArgumentException("Some of the specified chunks are not loaded!");
            }
            levelChunks.add(levelChunk);
        });
        return levelChunks;
    }

    @Override
    public float queryServer() {
        return this.tickManager.tickRate$getServerRate();
    }

    @Override
    public void rateServer(float rate) {
        if (rate < 1.0f) {
            throw new IllegalArgumentException("rate must be >= 1");
        }
        int roundRate = Math.round(rate);
        this.tickManager.tickRate$setServerRate(roundRate);
        ((TickRateEvents.ServerRate)TickRateEvents.SERVER_RATE.invoker()).onServerRate(this.server, roundRate);
    }

    @Override
    public void freezeServer(boolean freeze) {
        if (freeze) {
            if (this.tickManager.tickRate$isServerSprint()) {
                this.tickManager.method_54678();
            }
            if (this.tickManager.method_54752()) {
                this.tickManager.method_54676();
            }
        }
        this.tickManager.method_54675(freeze);
        ((TickRateEvents.ServerFreeze)TickRateEvents.SERVER_FREEZE.invoker()).onServerFreeze(this.server, freeze);
    }

    @Override
    public void stepServer(int stepTicks) {
        if (stepTicks < 0) {
            throw new IllegalArgumentException("stepTicks must be >= 0");
        }
        if (stepTicks == 0) {
            this.tickManager.method_54676();
        } else {
            if (!this.tickManager.method_54672(stepTicks)) {
                throw new IllegalStateException("server must be frozen to step!");
            }
            ((TickRateEvents.ServerStep)TickRateEvents.SERVER_STEP.invoker()).onServerStep(this.server, stepTicks);
        }
    }

    @Override
    public void sprintServer(int sprintTicks) {
        if (sprintTicks < 0) {
            throw new IllegalArgumentException("sprintTicks must be >= 0");
        }
        if (sprintTicks == 0) {
            this.tickManager.method_54678();
        } else {
            this.tickManager.method_54677(sprintTicks);
            ((TickRateEvents.ServerSprint)TickRateEvents.SERVER_SPRINT.invoker()).onServerSprint(this.server, sprintTicks);
        }
    }

    @Override
    public float queryEntity(class_1297 entity) {
        this.entityCheck(List.of(entity));
        return this.tickManager.tickRate$getEntityRate(entity);
    }

    @Override
    public void rateEntity(Collection<? extends class_1297> entities, float rate) {
        if (rate < 1.0f && rate != 0.0f) {
            throw new IllegalArgumentException("rate must be >= 1 or exactly 0");
        }
        this.entityCheck(entities);
        int roundRate = Math.round(rate);
        this.tickManager.tickRate$setRate(roundRate == 0 ? -1 : roundRate, entities);
        entities.forEach(entity -> ((TickRateEvents.EntityRate)TickRateEvents.ENTITY_RATE.invoker()).onEntityRate((class_1297)entity, roundRate));
    }

    @Override
    public void rateEntity(class_1297 entity, float rate) {
        this.rateEntity(List.of(entity), rate);
    }

    @Override
    public void freezeEntity(Collection<? extends class_1297> entities, boolean freeze) {
        this.entityCheck(entities);
        this.tickManager.tickRate$setFrozen(freeze, entities);
        entities.forEach(entity -> ((TickRateEvents.EntityFreeze)TickRateEvents.ENTITY_FREEZE.invoker()).onEntityFreeze((class_1297)entity, freeze));
    }

    @Override
    public void freezeEntity(class_1297 entity, boolean freeze) {
        this.freezeEntity(List.of(entity), freeze);
    }

    @Override
    public void stepEntity(Collection<? extends class_1297> entities, int stepTicks) {
        if (stepTicks < 0) {
            throw new IllegalArgumentException("stepTicks must be >= 0");
        }
        this.entityCheck(entities);
        if (this.tickManager.tickRate$step(stepTicks, entities)) {
            if (stepTicks != 0) {
                entities.forEach(entity -> ((TickRateEvents.EntityStep)TickRateEvents.ENTITY_STEP.invoker()).onEntityStep((class_1297)entity, stepTicks));
            }
        } else {
            throw new IllegalArgumentException("All of the specified entities must be frozen first and cannot be sprinting!");
        }
    }

    @Override
    public void stepEntity(class_1297 entity, int stepTicks) {
        this.stepEntity(List.of(entity), stepTicks);
    }

    @Override
    public void sprintEntity(Collection<? extends class_1297> entities, int sprintTicks) {
        if (sprintTicks < 0) {
            throw new IllegalArgumentException("sprintTicks must be >= 0");
        }
        this.entityCheck(entities);
        if (this.tickManager.tickRate$sprint(sprintTicks, entities)) {
            if (sprintTicks != 0) {
                entities.forEach(entity -> ((TickRateEvents.EntitySprint)TickRateEvents.ENTITY_SPRINT.invoker()).onEntitySprint((class_1297)entity, sprintTicks));
            }
        } else {
            throw new IllegalArgumentException("All of the specified entities must not be stepping!");
        }
    }

    @Override
    public void sprintEntity(class_1297 entity, int sprintTicks) {
        this.sprintEntity(List.of(entity), sprintTicks);
    }

    @Override
    public float queryChunk(class_1937 level, class_1923 chunkPos) {
        return this.tickManager.tickRate$getChunkRate(this.chunkCheck(level, List.of(chunkPos)).getFirst());
    }

    @Override
    public void rateChunk(class_1937 level, Collection<class_1923> chunks, float rate) {
        if (rate < 1.0f && rate != 0.0f) {
            throw new IllegalArgumentException("rate must be >= 1 or exactly 0");
        }
        List<class_2818> levelChunks = this.chunkCheck(level, chunks);
        int roundRate = Math.round(rate);
        this.tickManager.tickRate$setRate(roundRate == 0 ? -1 : roundRate, levelChunks);
        levelChunks.forEach(levelChunk -> ((TickRateEvents.ChunkRate)TickRateEvents.CHUNK_RATE.invoker()).onChunkRate((class_2818)levelChunk, roundRate));
    }

    @Override
    public void rateChunk(class_1937 level, class_1923 chunk, float rate) {
        this.rateChunk(level, List.of(chunk), rate);
    }

    @Override
    public void freezeChunk(class_1937 level, Collection<class_1923> chunks, boolean freeze) {
        List<class_2818> levelChunks = this.chunkCheck(level, chunks);
        this.tickManager.tickRate$setFrozen(freeze, levelChunks);
        levelChunks.forEach(levelChunk -> ((TickRateEvents.ChunkFreeze)TickRateEvents.CHUNK_FREEZE.invoker()).onChunkFreeze((class_2818)levelChunk, freeze));
    }

    @Override
    public void freezeChunk(class_1937 level, class_1923 chunk, boolean freeze) {
        this.freezeChunk(level, List.of(chunk), freeze);
    }

    @Override
    public void stepChunk(class_1937 level, Collection<class_1923> chunks, int stepTicks) {
        if (stepTicks < 0) {
            throw new IllegalArgumentException("stepTicks must be >= 0");
        }
        List<class_2818> levelChunks = this.chunkCheck(level, chunks);
        if (this.tickManager.tickRate$step(stepTicks, levelChunks)) {
            if (stepTicks != 0) {
                levelChunks.forEach(levelChunk -> ((TickRateEvents.ChunkStep)TickRateEvents.CHUNK_STEP.invoker()).onChunkStep((class_2818)levelChunk, stepTicks));
            }
        } else {
            throw new IllegalArgumentException("All of the specified chunks must be frozen first and cannot be sprinting!");
        }
    }

    @Override
    public void stepChunk(class_1937 level, class_1923 chunk, int stepTicks) {
        this.stepChunk(level, List.of(chunk), stepTicks);
    }

    @Override
    public void sprintChunk(class_1937 level, Collection<class_1923> chunks, int sprintTicks) {
        if (sprintTicks < 0) {
            throw new IllegalArgumentException("sprintTicks must be >= 0");
        }
        List<class_2818> levelChunks = this.chunkCheck(level, chunks);
        if (this.tickManager.tickRate$sprint(sprintTicks, levelChunks)) {
            if (sprintTicks != 0) {
                levelChunks.forEach(levelChunk -> ((TickRateEvents.ChunkSprint)TickRateEvents.CHUNK_SPRINT.invoker()).onChunkSprint((class_2818)levelChunk, sprintTicks));
            }
        } else {
            throw new IllegalArgumentException("All of the specified chunks must not be stepping!");
        }
    }

    @Override
    public void sprintChunk(class_1937 level, class_1923 chunk, int sprintTicks) {
        this.sprintChunk(level, List.of(chunk), sprintTicks);
    }
}

