/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.mixin.client.render;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.DeltaTrackerInfo;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import io.github.dennisochulor.tickrate.injected_interface.TickRateDeltaTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_9779.class_9781.class})
public class DeltaTracker$TimerMixin
implements TickRateDeltaTracker {
    @Shadow
    private long field_51962;
    @Shadow
    private float field_51959;
    @Shadow
    @Final
    private float field_51964;
    @Unique
    private long lastLastTimeMillis;
    @Unique
    private float lastPartialTick;
    @Unique
    private int movingI;
    @Unique
    private int i;
    @Unique
    private final Map<Integer, DeltaTrackerInfo> prevPartialTicks = new HashMap<Integer, DeltaTrackerInfo>();
    @Unique
    private final Set<Integer> isUpdated = new HashSet<Integer>();
    @Unique
    private DeltaTrackerInfo clientPlayerDeltaTrackerInfo = DeltaTrackerInfo.NO_ANIMATE;
    @Unique
    private boolean clientPlayerUpdated = false;

    @Inject(method={"method_60639(J)I"}, at={@At(value="HEAD")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        this.lastLastTimeMillis = this.field_51962;
        this.lastPartialTick = this.field_51959;
        this.isUpdated.clear();
        this.clientPlayerUpdated = false;
    }

    @Inject(method={"method_60639(J)I"}, at={@At(value="TAIL")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir, @Local int i) {
        this.i = i;
        TickRateClientManager.clearCache();
    }

    @Override
    @Unique
    public DeltaTrackerInfo tickRate$getDeltaTrackerInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.isUpdated.contains(tps)) {
            return this.prevPartialTicks.get(tps);
        }
        float dynamicDeltaTicks = (float)(this.field_51962 - this.lastLastTimeMillis) / Math.max(millisPerTick, this.field_51964);
        float specificPartialTick = this.prevPartialTicks.getOrDefault(tps, new DeltaTrackerInfo(this.lastPartialTick, 0, 0.0f)).partialTick() + dynamicDeltaTicks;
        int i = (int)specificPartialTick;
        DeltaTrackerInfo info = new DeltaTrackerInfo(specificPartialTick -= (float)i, i, dynamicDeltaTicks);
        this.isUpdated.add(tps);
        this.prevPartialTicks.put(tps, info);
        return info;
    }

    @Override
    @Unique
    public DeltaTrackerInfo tickRate$getClientPlayerDeltaTrackerInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.clientPlayerUpdated) {
            return this.clientPlayerDeltaTrackerInfo;
        }
        float deltaTicks = (float)(this.field_51962 - this.lastLastTimeMillis) / millisPerTick;
        float specificPartialTick = this.clientPlayerDeltaTrackerInfo.partialTick() + deltaTicks;
        int i = (int)specificPartialTick;
        this.clientPlayerDeltaTrackerInfo = new DeltaTrackerInfo(specificPartialTick -= (float)i, i, deltaTicks);
        this.clientPlayerUpdated = true;
        return this.clientPlayerDeltaTrackerInfo;
    }

    @Override
    public void tickRate$setMovingI(int newI) {
        this.movingI = newI;
    }

    @Override
    public int tickRate$getMovingI() {
        return this.movingI;
    }

    @Override
    public int tickRate$getI() {
        return this.i;
    }
}

