/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.mixin.core;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.github.dennisochulor.tickrate.TickRateAttachments;
import io.github.dennisochulor.tickrate.TickState;
import io.github.dennisochulor.tickrate.injected_interface.TickRateTickManager;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_4802;
import net.minecraft.class_5218;
import net.minecraft.class_8915;
import net.minecraft.class_8921;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8915.class})
public abstract class ServerTickRateManagerMixin
extends class_8921
implements TickRateTickManager {
    @Unique
    private int ticks = 0;
    @Unique
    private final Map<String, Boolean> ticked = new HashMap<String, Boolean>();
    @Unique
    private final SortedMap<Integer, Integer> tickers = new TreeMap(Comparator.reverseOrder());
    @Unique
    private int sprintAvgTicksPerSecond = -1;
    @Unique
    private int numberOfIndividualSprints = 0;
    @Unique
    private File datafile;
    @Unique
    private final Map<String, Float> migrationData = new HashMap<String, Float>();
    @Unique
    private float nominalTickRateMigration = -1.0f;
    @Shadow
    @Final
    private MinecraftServer field_46924;
    @Shadow
    private long field_46922;

    @Shadow
    public abstract void method_54671(float var1);

    @Inject(method={"method_54672(I)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_8915;method_54682()V")})
    public void serverTickManager$step(int ticks, CallbackInfoReturnable<Boolean> cir) {
        ++this.field_46963;
        TickState state = (TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER);
        TickState newState = state.withStepping(true);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
        this.method_54671(state.rate());
    }

    @Inject(method={"method_54676()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_8915;method_54682()V")})
    public void stopStepping(CallbackInfoReturnable<Boolean> cir) {
        TickState newState = ((TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER)).withStepping(false);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
        this.updateFastestTicker();
    }

    public void method_54755() {
        boolean bl = this.field_46964 = !this.field_46965 || this.field_46963 > 0;
        if (this.field_46963 > 0) {
            --this.field_46963;
            if (this.field_46963 == 0) {
                this.updateFastestTicker();
                TickState newState = ((TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER)).withStepping(false);
                this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
            }
        }
    }

    @Inject(method={"method_54677(I)Z"}, at={@At(value="TAIL")})
    public void startSprint(int ticks, CallbackInfoReturnable<Boolean> cir) {
        TickState newState = ((TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER)).withSprinting(true);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
    }

    @Inject(method={"method_54683()V"}, at={@At(value="TAIL")})
    public void finishSprinting(CallbackInfo ci) {
        TickState newState = ((TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER)).withSprinting(false);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
    }

    @Inject(method={"method_54675(Z)V"}, at={@At(value="TAIL")})
    public void setFrozen(CallbackInfo ci, @Local(argsOnly=true) boolean frozen) {
        TickState newState = ((TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER)).withFrozen(frozen);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
    }

    @Overwrite
    public boolean method_54670() {
        return this.tickRate$isServerSprint() || this.tickRate$isIndividualSprint();
    }

    @Override
    public void tickRate$serverStarting() {
        this.datafile = this.field_46924.method_27050(class_5218.field_24188).resolve("data/TickRateData.nbt").toFile();
        if (this.datafile.exists()) {
            try {
                class_2487 nbt = class_2507.method_10633((Path)this.datafile.toPath());
                this.nominalTickRateMigration = nbt.method_10583("nominalTickRate").orElse(Float.valueOf(-1.0f)).floatValue();
                ((MapLike)class_2509.field_11560.method_29163(nbt.method_10580("entities")).getOrThrow()).entries().forEach(pair -> {
                    String key = (String)class_2509.field_11560.method_10656((class_2520)pair.getFirst()).getOrThrow();
                    float value = ((Number)class_2509.field_11560.method_10645((class_2520)pair.getSecond()).getOrThrow()).floatValue();
                    this.migrationData.put(key, Float.valueOf(value));
                });
                class_2509.field_11560.method_29163(nbt.method_10580("chunks")).ifSuccess(nbtElementMapLike -> nbtElementMapLike.entries().forEach(pair -> {
                    String key = (String)class_2509.field_11560.method_10656((class_2520)pair.getFirst()).getOrThrow();
                    float value = ((Number)class_2509.field_11560.method_10645((class_2520)pair.getSecond()).getOrThrow()).floatValue();
                    this.migrationData.put(key, Float.valueOf(value));
                }));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void tickRate$serverStarted() {
        TickState serverState = (TickState)this.field_46924.method_30002().getAttachedOrCreate(TickRateAttachments.TICK_STATE_SERVER);
        if (this.nominalTickRateMigration != -1.0f) {
            serverState = serverState.withRate((int)this.nominalTickRateMigration);
        }
        TickState finalServerState = serverState;
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)finalServerState));
        this.updateTickersMap(finalServerState.rate(), 1);
    }

    @Override
    public void tickRate$saveData() {
        if (!this.migrationData.isEmpty()) {
            class_2487 nbt = new class_2487();
            RecordBuilder entitiesNbt = class_2509.field_11560.mapBuilder();
            this.migrationData.forEach((k, v) -> entitiesNbt.add(k, (Object)class_2509.field_11560.method_10662(v.floatValue())));
            nbt.method_10566("entities", (class_2520)entitiesNbt.build((Object)class_2509.field_11560.method_10668()).getOrThrow());
            try {
                class_2507.method_10630((class_2487)nbt, (Path)this.datafile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.datafile.exists()) {
            this.datafile.delete();
        }
    }

    @Override
    public boolean tickRate$shouldTickEntity(class_1297 entity) {
        boolean shouldTick;
        String key = entity.method_5845();
        Boolean cachedShouldTick = this.ticked.get(key);
        if (cachedShouldTick != null) {
            return cachedShouldTick;
        }
        if (this.tickRate$isServerSprint()) {
            return true;
        }
        if (this.method_54754()) {
            if (entity instanceof class_3222) {
                return true;
            }
            return this.method_54752();
        }
        TickState tickState = (TickState)entity.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT);
        if (tickState.sprinting()) {
            int sprintTicks = (Integer)entity.getAttached(TickRateAttachments.SPRINT_TICKS);
            if (sprintTicks == 0) {
                entity.removeAttached(TickRateAttachments.SPRINT_TICKS);
                entity.modifyAttached(TickRateAttachments.TICK_STATE, tickState1 -> tickState1.withSprinting(false));
                --this.numberOfIndividualSprints;
                shouldTick = false;
            } else {
                entity.modifyAttached(TickRateAttachments.SPRINT_TICKS, sprintTicks1 -> {
                    sprintTicks1 = sprintTicks1 - 1;
                    return sprintTicks1;
                });
                shouldTick = true;
            }
        } else if (tickState.frozen() && !tickState.stepping()) {
            shouldTick = false;
        } else {
            shouldTick = tickState.rate() != -1 ? this.internalShouldTick(tickState.rate()) : this.tickRate$shouldTickChunk(entity.method_73183(), entity.method_31476());
            if (shouldTick && tickState.stepping()) {
                int stepTicks = (Integer)entity.getAttached(TickRateAttachments.STEP_TICKS);
                if (stepTicks == 0) {
                    entity.removeAttached(TickRateAttachments.STEP_TICKS);
                    entity.modifyAttached(TickRateAttachments.TICK_STATE, tickState1 -> tickState1.withStepping(false));
                } else {
                    entity.modifyAttached(TickRateAttachments.STEP_TICKS, stepTicks1 -> {
                        stepTicks1 = stepTicks1 - 1;
                        return stepTicks1;
                    });
                }
            }
        }
        this.ticked.put(key, shouldTick);
        return shouldTick;
    }

    @Override
    public boolean tickRate$shouldTickChunk(class_1937 level, class_1923 chunkPos) {
        String key = String.valueOf(level.method_27983().method_29177()) + "-" + chunkPos.method_8324();
        Boolean cachedShouldTick = this.ticked.get(key);
        if (cachedShouldTick != null) {
            return cachedShouldTick;
        }
        class_2818 levelChunk = (class_2818)level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
        if (levelChunk == null) {
            this.ticked.put(key, false);
            return false;
        }
        return this.tickRate$shouldTickChunk(levelChunk);
    }

    @Override
    public boolean tickRate$shouldTickChunk(class_2818 chunk) {
        boolean shouldTick;
        String key = String.valueOf(chunk.method_12200().method_27983().method_29177()) + "-" + chunk.method_12004().method_8324();
        Boolean cachedShouldTick = this.ticked.get(key);
        if (cachedShouldTick != null) {
            return cachedShouldTick;
        }
        if (this.tickRate$isServerSprint()) {
            return true;
        }
        if (this.method_54754()) {
            return this.method_54752();
        }
        TickState tickState = (TickState)chunk.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT);
        if (tickState.sprinting()) {
            int sprintTicks = (Integer)chunk.getAttached(TickRateAttachments.SPRINT_TICKS);
            if (sprintTicks == 0) {
                chunk.removeAttached(TickRateAttachments.SPRINT_TICKS);
                chunk.modifyAttached(TickRateAttachments.TICK_STATE, tickState1 -> tickState1.withSprinting(false));
                --this.numberOfIndividualSprints;
                shouldTick = false;
            } else {
                chunk.modifyAttached(TickRateAttachments.SPRINT_TICKS, sprintTicks1 -> {
                    sprintTicks1 = sprintTicks1 - 1;
                    return sprintTicks1;
                });
                shouldTick = true;
            }
        } else if (tickState.frozen() && !tickState.stepping()) {
            shouldTick = false;
        } else {
            shouldTick = tickState.rate() != -1 ? this.internalShouldTick(tickState.rate()) : this.tickRate$shouldTickServer();
            if (shouldTick && tickState.stepping()) {
                int stepTicks = (Integer)chunk.getAttached(TickRateAttachments.STEP_TICKS);
                if (stepTicks == 0) {
                    chunk.removeAttached(TickRateAttachments.STEP_TICKS);
                    chunk.modifyAttached(TickRateAttachments.TICK_STATE, tickState1 -> tickState1.withStepping(false));
                } else {
                    chunk.modifyAttached(TickRateAttachments.STEP_TICKS, stepTicks1 -> {
                        stepTicks1 = stepTicks1 - 1;
                        return stepTicks1;
                    });
                }
            }
        }
        this.ticked.put(key, shouldTick);
        return shouldTick;
    }

    @Override
    public boolean tickRate$shouldTickServer() {
        Boolean cachedShouldTick = this.ticked.get("server");
        if (cachedShouldTick != null) {
            return cachedShouldTick;
        }
        boolean shouldTick = this.tickRate$isServerSprint() ? true : (this.method_54754() ? this.method_54752() : this.internalShouldTick(this.tickRate$getServerRate()));
        this.ticked.put("server", shouldTick);
        return shouldTick;
    }

    @Override
    public void tickRate$updateLoad(AttachmentTarget attachmentTarget, boolean loaded) {
        this.migrate(attachmentTarget);
        TickState tickState = (TickState)attachmentTarget.getAttached(TickRateAttachments.TICK_STATE);
        if (tickState == null) {
            return;
        }
        if (loaded) {
            if (tickState.sprinting()) {
                ++this.numberOfIndividualSprints;
            }
            if (tickState.rate() != -1) {
                this.updateTickersMap(tickState.rate(), 1);
            }
            if ((float)tickState.rate() > this.field_46961) {
                this.updateFastestTicker();
            }
        } else {
            if (tickState.sprinting()) {
                --this.numberOfIndividualSprints;
            }
            if (tickState.rate() != -1) {
                this.updateTickersMap(tickState.rate(), -1);
            }
            if ((float)tickState.rate() == this.field_46961) {
                this.updateFastestTicker();
            }
        }
    }

    @Override
    public void tickRate$setServerRate(int rate) {
        TickState prevState = (TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER);
        TickState newState = prevState.withRate(rate);
        this.field_46924.method_3738().forEach(serverLevel -> serverLevel.setAttached(TickRateAttachments.TICK_STATE_SERVER, (Object)newState));
        this.updateTickersMap(prevState.rate(), -1);
        this.updateTickersMap(rate, 1);
        this.updateFastestTicker();
    }

    @Override
    public int tickRate$getServerRate() {
        return this.tickRate$getServerTickState().rate();
    }

    @Override
    public TickState tickRate$getServerTickState() {
        return (TickState)this.field_46924.method_30002().getAttached(TickRateAttachments.TICK_STATE_SERVER);
    }

    @Override
    public void tickRate$ticked() {
        if (this.tickRate$isIndividualSprint()) {
            ++this.ticks;
            if (this.ticks > this.sprintAvgTicksPerSecond) {
                this.ticks = 1;
                this.sprintAvgTicksPerSecond = (int)(class_4802.field_33868 / this.field_46924.method_54834());
            }
        } else {
            this.sprintAvgTicksPerSecond = -1;
            ++this.ticks;
            if ((float)this.ticks > this.field_46961) {
                this.ticks = 1;
            }
        }
        this.ticked.clear();
    }

    @Override
    public boolean tickRate$isIndividualSprint() {
        return this.numberOfIndividualSprints > 0;
    }

    @Override
    public boolean tickRate$isServerSprint() {
        return this.field_46922 > 0L;
    }

    @Override
    public void tickRate$setRate(int rate, Collection<? extends AttachmentTarget> targets) {
        targets.forEach(target -> target.modifyAttached(TickRateAttachments.TICK_STATE, tickState -> {
            TickState tickState2 = tickState = tickState == null ? TickState.DEFAULT : tickState;
            if (tickState.rate() != -1) {
                this.updateTickersMap(tickState.rate(), -1);
            }
            return tickState.withRate(rate);
        }));
        this.updateTickersMap(rate, targets.size());
        this.updateFastestTicker();
    }

    @Override
    public void tickRate$setFrozen(boolean frozen, Collection<? extends AttachmentTarget> targets) {
        targets.forEach(target -> target.modifyAttached(TickRateAttachments.TICK_STATE, tickState -> {
            tickState = tickState == null ? TickState.DEFAULT : tickState;
            if ((tickState = tickState.withFrozen(frozen)) != null && frozen) {
                tickState = tickState.withSprinting(false);
            }
            return tickState;
        }));
    }

    @Override
    public boolean tickRate$step(int steps, Collection<? extends AttachmentTarget> targets) {
        boolean canStep = targets.stream().allMatch(target -> {
            TickState tickState = (TickState)target.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT);
            return tickState.frozen() && !tickState.sprinting();
        });
        if (canStep) {
            targets.forEach(target -> {
                target.modifyAttached(TickRateAttachments.TICK_STATE, tickState -> {
                    tickState = tickState == null ? TickState.DEFAULT : tickState;
                    return tickState.withStepping(steps > 0);
                });
                target.setAttached(TickRateAttachments.STEP_TICKS, (Object)(steps > 0 ? Integer.valueOf(steps) : null));
            });
        }
        return canStep;
    }

    @Override
    public boolean tickRate$sprint(int ticks, Collection<? extends AttachmentTarget> targets) {
        boolean canSprint = targets.stream().noneMatch(target -> ((TickState)target.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT)).stepping());
        if (canSprint) {
            targets.forEach(target -> {
                target.modifyAttached(TickRateAttachments.TICK_STATE, tickState -> {
                    TickState tickState2 = tickState = tickState == null ? TickState.DEFAULT : tickState;
                    if (tickState.sprinting() && ticks == 0) {
                        --this.numberOfIndividualSprints;
                    } else if (!tickState.sprinting() && ticks > 0) {
                        ++this.numberOfIndividualSprints;
                    }
                    return tickState.withSprinting(ticks > 0);
                });
                target.setAttached(TickRateAttachments.SPRINT_TICKS, (Object)(ticks > 0 ? Integer.valueOf(ticks) : null));
            });
        }
        return canSprint;
    }

    @Override
    public int tickRate$getEntityRate(class_1297 entity) {
        if (this.method_54752()) {
            return this.tickRate$getServerRate();
        }
        if (entity.method_5765()) {
            return this.tickRate$getEntityRate(entity.method_5668());
        }
        int rate = ((TickState)entity.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT)).rate();
        if (rate != -1) {
            return rate;
        }
        class_1923 chunkPos = entity.method_31476();
        return this.tickRate$getChunkRate((class_2818)entity.method_73183().method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false));
    }

    @Override
    public int tickRate$getChunkRate(class_2818 chunk) {
        if (this.method_54752()) {
            return this.tickRate$getServerRate();
        }
        int rate = ((TickState)chunk.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT)).rate();
        if (rate != -1) {
            return rate;
        }
        return this.tickRate$getServerRate();
    }

    @Override
    public TickState tickRate$getEntityTickStateShallow(class_1297 entity) {
        return (TickState)entity.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT);
    }

    @Override
    public TickState tickRate$getEntityTickStateDeep(class_1297 entity) {
        if (entity.method_5765()) {
            return this.tickRate$getEntityTickStateDeep(entity.method_5668());
        }
        TickState state = this.tickRate$getEntityTickStateShallow(entity);
        TickState serverState = this.tickRate$getServerTickState();
        if (state.rate() == -1) {
            TickState chunkState = this.tickRate$getChunkTickStateDeep(entity.method_73183(), entity.method_31476());
            state = state.equals(TickState.DEFAULT) ? chunkState : state.withRate(chunkState.rate());
        }
        if (serverState.frozen() || serverState.sprinting() || serverState.stepping()) {
            state = serverState.withRate(serverState.stepping() ? serverState.rate() : state.rate());
        }
        return state;
    }

    @Override
    public TickState tickRate$getChunkTickStateShallow(class_1937 level, class_1923 chunkPos) {
        class_2791 chunk = level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423, false);
        return chunk == null ? TickState.DEFAULT : (TickState)chunk.getAttachedOrElse(TickRateAttachments.TICK_STATE, (Object)TickState.DEFAULT);
    }

    @Override
    public TickState tickRate$getChunkTickStateDeep(class_1937 level, class_1923 chunkPos) {
        TickState state = this.tickRate$getChunkTickStateShallow(level, chunkPos);
        int rate = state.rate();
        TickState serverState = this.tickRate$getServerTickState();
        if (state.rate() == -1) {
            rate = serverState.rate();
        }
        if (serverState.frozen() || serverState.sprinting() || serverState.stepping()) {
            return serverState.withRate(serverState.stepping() ? serverState.rate() : rate);
        }
        return state.withRate(rate);
    }

    @Unique
    private boolean internalShouldTick(int tickRate) {
        float fastestTickRate = this.tickRate$isIndividualSprint() ? (float)this.sprintAvgTicksPerSecond : this.field_46961;
        double d = (fastestTickRate - 1.0f) / (float)(tickRate + 1);
        if ((float)tickRate == fastestTickRate) {
            return true;
        }
        if (this.ticks == 1) {
            return Math.ceil(1.0 + 1.0 * d) == 1.0;
        }
        double eventsToTick = (double)(this.ticks - 1) / d;
        if (eventsToTick >= (double)tickRate) {
            return Math.ceil(1.0 + (double)tickRate * d) == (double)this.ticks;
        }
        double floorEventToTick = Math.floor(eventsToTick);
        double ceilEventToTick = Math.ceil(eventsToTick);
        if (Math.ceil(1.0 + floorEventToTick * d) == (double)this.ticks) {
            return true;
        }
        return Math.ceil(1.0 + ceilEventToTick * d) == (double)this.ticks;
    }

    @Unique
    private void updateFastestTicker() {
        if (this.method_54752()) {
            return;
        }
        int fastest = this.tickers.firstKey();
        if ((float)fastest != this.field_46961) {
            this.method_54671(fastest);
            this.ticks = 1;
        }
    }

    @Unique
    private void updateTickersMap(int rate, int change) {
        if (change > 0) {
            this.tickers.merge(rate, change, Integer::sum);
        } else if (change < 0) {
            this.tickers.compute(rate, (k, v) -> {
                if (v == null) {
                    throw new IllegalStateException("When removing rate from tickers map, " + rate + " TPS already 0");
                }
                if ((v = Integer.valueOf(v + change)) < 0) {
                    throw new IllegalStateException("When removing rate from tickers map, " + rate + " TPS deducted to below 0 (" + v + ")");
                }
                return v == 0 ? null : v;
            });
        } else {
            throw new IllegalArgumentException("change must not be 0");
        }
    }

    @Unique
    private void migrate(AttachmentTarget target) {
        if (this.migrationData.isEmpty()) {
            return;
        }
        AttachmentTarget attachmentTarget = target;
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0 -> {
                class_1297 e = (class_1297)attachmentTarget2;
                yield e.method_5845();
            }
            case 1 -> {
                class_2818 levelChunk = (class_2818)attachmentTarget2;
                yield String.valueOf(levelChunk.method_12200().method_27983().method_29177()) + "-" + levelChunk.method_12004().method_8324();
            }
            default -> "";
        };
        Float tickRate = this.migrationData.remove(key);
        if (tickRate != null) {
            target.setAttached(TickRateAttachments.TICK_STATE, (Object)TickState.ofRate(tickRate.intValue()));
        }
    }
}

