package io.github.dennisochulor.tickrate.mixin.chunk;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3898;
import net.minecraft.class_8915;

@Mixin(class_3898.class)
public class ServerChunkLoadingManagerMixin {

    @Shadow @Final class_3218 world;

    @Unique private boolean bl;

    @ModifyVariable(method = "tickEntityMovement", at = @At("STORE"))
    boolean tickEntityMovement$getBl(boolean bl) {
        this.bl = bl;
        return bl;
    }

    /**
     * This relates to MC-76973
     * Logically, this should apply uniformly to all entities, but for some unknown reason only projectiles/items
     * work properly with this. Other entities will become noticeably less smooth at low TPS. Hence the
     * distinction below is required. Sigh.
     */
    @Redirect(method = "tickEntityMovement", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/EntityTrackerEntry;tick()V"))
    void tickEntityMovement$tickEntityTrackerEntry(class_3231 entry) {
        class_1297 entity = entry.tickRate$getEntity();
        if(entity instanceof class_1676 || entity instanceof class_1542) {
            class_8915 tickManager = (class_8915) world.method_54719();
            if(this.bl || tickManager.tickRate$shouldTickEntity(entity)) entry.method_18756();
        }
        else entry.method_18756();
    }

    @Redirect(method = "collectSpawningChunks", at = @At(value = "INVOKE", target = "Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private <E> boolean collectSpawningChunks(List<E> list, E e) {
        class_8915 tickManager = (class_8915) world.method_54719();
        class_2818 chunk = (class_2818) e;
        if(tickManager.tickRate$shouldTickChunk(chunk))
            return list.add(e);
        else return false;
    }

}
