package io.github.dennisochulor.tickrate.mixin.client.particle;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import net.minecraft.class_11940;
import net.minecraft.class_1923;
import net.minecraft.class_3940;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

/**
 * Since 1.21.9, Particle#render no longer exists.
 * Different ParticleRenderers can decide how to render their particles on their own.
 * So there is no choice but to individually mixin to each ParticleRenderer, luckily vanilla has only 4 (and the NoRender one is moot).
 * However, for modded ParticleRenderers, idk man...
 */
@Mixin(class_11940.class)
public class BillboardParticleRendererMixin {

    @ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/BillboardParticle;render(Lnet/minecraft/client/particle/BillboardParticleSubmittable;Lnet/minecraft/client/render/Camera;F)V"))
    private float render(float tickProgress, @Local class_3940 particle) {
        return TickRateClientManager.getChunkTickProgress(new class_1923(particle.tickRate$getBlockPos())).tickProgress();
    }

}
