package io.github.dennisochulor.tickrate.mixin.client.particle;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import net.minecraft.class_11938;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_703;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin({class_11938.class})
public class ParticleRendererMixin {

    @WrapOperation(method = "tickParticle", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/Particle;tick()V"))
    private void tickParticle(class_703 particle, Operation<Void> original) { // particle ticking
        if(TickRateClientManager.serverHasMod()) {
            // Modded particle types can't be accounted for properly, so just give em playerChunkI
            class_3999 sheet = particle.method_74274();
            boolean isVanillaParticle = sheet == class_3999.field_62622 || sheet == class_3999.field_17832 || sheet == class_3999.field_62624 || sheet == class_3999.field_62623;
            int i = isVanillaParticle ? TickRateClientManager.getChunkTickProgress(new class_1923(particle.tickRate$getBlockPos())).i() : TickRateClientManager.getChunkTickProgress(class_310.method_1551().field_1724.method_31476()).i();

            class_9779 renderTickCounter = class_310.method_1551().method_61966();
            if(renderTickCounter.tickRate$getMovingI() < i) {
                original.call(particle);
            }
        }
        else original.call(particle);
    }

}
