package io.github.dennisochulor.tickrate.mixin.client.sound;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.TickRate;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import io.github.dennisochulor.tickrate.TickState;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_638.class)
public class ClientWorldMixin {

    @Shadow @Final private class_310 client;

    /**
     * Entity pitch change is handled by EntityMixin (common side) already
     */
    @ModifyVariable(method = "playSound(DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FFZJ)V", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSound(float pitch, @Local(argsOnly = true, ordinal = 0) double x, @Local(argsOnly = true, ordinal = 1) double y, @Local(argsOnly = true, ordinal = 2) double z, @Local(argsOnly = true) class_3419 category) {
        return switch(category) {
            case field_15250,field_15253,field_61058,field_15247,field_15246,field_15254,field_15251 -> pitch;
            case field_15248 -> {
                TickState state = TickRateClientManager.getEntityState(client.field_1724);
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15252 -> {
                TickState state = TickRateClientManager.getServerState();
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15245, field_15256 -> {
                TickState state = TickRateClientManager.getChunkState(new class_1923(new class_2338(class_3532.method_15357(x), class_3532.method_15357(y), class_3532.method_15357(z))));
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
        };
    }

    /**
     * Entity pitch change is handled by EntityMixin (common side) already
     * Entity is assumed to be MinecraftClient#player
     */
    @ModifyVariable(method = "playSoundClient(Lnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSoundClient(float pitch, @Local(argsOnly = true) class_3419 category) {
        return switch(category) {
            case field_15250,field_15253,field_61058,field_15247,field_15246,field_15254,field_15251 -> pitch;
            case field_15248 -> {
                TickState state = TickRateClientManager.getEntityState(client.field_1724);
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15252 -> {
                TickState state = TickRateClientManager.getServerState();
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15245, field_15256 -> {
                TickState state = TickRateClientManager.getChunkState(client.field_1724.method_31476());
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
        };
    }

    @ModifyVariable(method = "playSoundFromEntity", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSoundFromEntity(float pitch, @Local(argsOnly = true, ordinal = 1) class_1297 entity) {
        TickState state = TickRateClientManager.getEntityState(entity);
        if(state.sprinting()) return TickRate.MAX_SOUND_PITCH;
        else return pitch * (state.rate() / 20.0F);
    }

    @ModifyVariable(method = "playSoundFromEntityClient", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSoundFromEntityClient(float pitch, @Local(argsOnly = true) class_1297 entity) {
        TickState state = TickRateClientManager.getEntityState(entity);
        if(state.sprinting()) return TickRate.MAX_SOUND_PITCH;
        else return pitch * (state.rate() / 20.0F);
    }

}
