package io.github.dennisochulor.tickrate.mixin.core;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_6757;
import net.minecraft.class_8915;
import net.minecraft.class_8921;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3218.class)
public abstract class ServerWorldMixin {

    @Shadow public abstract class_8921 getTickManager();

    @Shadow @Final private class_6757<class_2248> blockTickScheduler;
    @Shadow @Final private class_6757<class_3611> fluidTickScheduler;

    @Inject(method = "<init>", at = @At("TAIL"))
    private void init(CallbackInfo ci) {
        this.blockTickScheduler.tickRate$setWorld((class_3218) (Object)this);
        this.fluidTickScheduler.tickRate$setWorld((class_3218) (Object)this);
    }

    @ModifyVariable(method = "tick(Ljava/util/function/BooleanSupplier;)V", at = @At("STORE"), ordinal = 0)
    private boolean tick$shouldTick(boolean value) {
        class_8915 tickManager = (class_8915) getTickManager();
        return tickManager.tickRate$shouldTickServer();
    }

    @Inject(method = "tick(Ljava/util/function/BooleanSupplier;)V",  at = @At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args = "ldc=tickPending"))
    private void tick$modifyBl(CallbackInfo ci, @Local LocalBooleanRef bl) {
        class_8915 serverTickManager = (class_8915) getTickManager();
        if(serverTickManager.tickRate$isServerSprint()) bl.set(true);
        else if(serverTickManager.method_54754()) bl.set(serverTickManager.method_54752());
        else bl.set(true);
    }

    @Inject(method = "tick(Ljava/util/function/BooleanSupplier;)V",  at = @At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args = "ldc=raid"))
    private void tick$modifyBl2(CallbackInfo ci, @Local LocalBooleanRef bl) {
        class_8915 tickManager = (class_8915) getTickManager();
        bl.set(tickManager.tickRate$shouldTickServer());
    }

    @Inject(method = "tick(Ljava/util/function/BooleanSupplier;)V",  at = @At(value = "INVOKE_STRING", target = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args = "ldc=blockEvents"))
    private void tick$modifyBl3(CallbackInfo ci, @Local LocalBooleanRef bl) {
        class_8915 serverTickManager = (class_8915) getTickManager();
        if(serverTickManager.tickRate$isServerSprint()) bl.set(true);
        else if(serverTickManager.method_54754()) bl.set(serverTickManager.method_54752());
        else bl.set(true);
    }

    @Inject(method = "method_31420",  at = @At(value = "HEAD"), cancellable = true)
    private void tick$entity(class_8921 tickManager, class_3695 profiler, class_1297 entity, CallbackInfo ci) {
        class_8915 tickManager1 = (class_8915) tickManager;
        if(!tickManager1.tickRate$shouldTickEntity(entity)) ci.cancel();
    }

    // for random ticks
    @Inject(method = "tickChunk", at = @At("HEAD"), cancellable = true)
    private void tickChunk(class_2818 chunk, int randomTickSpeed, CallbackInfo ci) {
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickChunk(chunk))
            ci.cancel();
    }

    // tickSpawners doesn't differentiate between chunks, so use server TPS i guess...
    @Inject(method = "tickSpawners", at = @At("HEAD"), cancellable = true)
    private void tickSpawners(boolean spawnMonsters, CallbackInfo ci) {
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickServer())
            ci.cancel();
    }

    // handles block entity ticking, among other things
    @Inject(method = "shouldTickBlocksInChunk", at = @At("HEAD"), cancellable = true)
    public void shouldTickBlocksInChunk(long chunkPos, CallbackInfoReturnable<Boolean> cir) {
        class_3218 world = (class_3218) (Object) this;
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickChunk(world, new class_1923(chunkPos))) cir.setReturnValue(false);
    }

    @Inject(method = "shouldTickChunkAt", at = @At("HEAD"), cancellable = true)
    public void shouldTickChunkAt(class_1923 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3218 world = (class_3218) (Object) this;
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickChunk(world, pos)) cir.setReturnValue(false);
    }

    @Inject(method = "shouldTickEntityAt", at = @At("HEAD"), cancellable = true)
    public void shouldTickEntityAt(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3218 world = (class_3218) (Object) this;
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickChunk(world, new class_1923(pos))) cir.setReturnValue(false);
    }

    @Inject(method = "canSpawnEntitiesAt", at = @At("HEAD"), cancellable = true)
    public void canSpawnEntitiesAt(class_1923 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3218 world = (class_3218) (Object) this;
        class_8915 tickManager = (class_8915) getTickManager();
        if(!tickManager.tickRate$shouldTickChunk(world, pos)) cir.setReturnValue(false);
    }

}
