package io.github.dennisochulor.tickrate.mixin.networking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.dennisochulor.tickrate.TickRateHelloPayload;
import io.github.dennisochulor.tickrate.TickState;
import io.github.dennisochulor.tickrate.injected_interface.TickRateServerPlayNetworkHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2626;
import net.minecraft.class_2828;
import net.minecraft.class_2846;
import net.minecraft.class_2885;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8913;
import net.minecraft.class_8915;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin implements TickRateServerPlayNetworkHandler {

    @Shadow public class_3222 player;
    @Shadow public abstract void requestTeleport(double x, double y, double z, float yaw, float pitch);
    @Shadow public abstract void updateSequence(int sequence);

    @Unique private boolean hasClientMod;
    // Only used if hasClientMod == false
    @Unique private boolean wasFrozen = false;
    @Unique private class_8913 prevPacket = null;


    @Override
    public boolean tickRate$hasClientMod() {
        return hasClientMod;
    }


    @Inject(method = "<init>", at = @At("TAIL"))
    private void init(CallbackInfo ci) {
        hasClientMod = ServerPlayNetworking.canSend((class_3244) (Object) this, TickRateHelloPayload.ID);
    }

    @WrapOperation(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;tickMovement()Z"))
    private boolean tick(class_3244 handler, Operation<Boolean> original) {
        class_8915 tickManager = player.method_51469().method_8503().method_54833();

        // For players without the mod client-side, allow some degree of TPS control
        // Regardless of whether this player should tick or not, send update packet if applicable
        if (!hasClientMod) {
            TickState state = tickManager.tickRate$getEntityTickStateDeep(player);
            class_8913 newPacket = new class_8913(state.sprinting() ? 100 : state.rate(), tickManager.method_54754());
            if (!newPacket.equals(prevPacket)) {
                handler.method_14364(newPacket);
                prevPacket = newPacket;
            }

            if ( (!wasFrozen && state.frozen()) && !(state.stepping() || state.sprinting()) ) {
                wasFrozen = true;
            }
            else if ( (wasFrozen && !state.frozen()) || (wasFrozen && (state.stepping() || state.sprinting())) ) {
                wasFrozen = false;
            }
        }


        // call tickMovement() according to player's TPS
        // the rest of the handler should still tick even if shouldTickEntity is false
        if (tickManager.tickRate$shouldTickEntity(player)) return original.call(handler);
        else return false;
    }



    // Mimic player freeze for clients without the mod

    @Inject(method = {"onPlayerInput","onPlayerInteractEntity","onPlayerInteractItem"}, at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V",
            shift = At.Shift.AFTER), cancellable = true)
    private void onPlayerGeneralAction(CallbackInfo ci) {
        if (!hasClientMod && wasFrozen) {
            player.method_14234();
            ci.cancel();
        }
    }

    @Inject(method = "onPlayerInteractBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V",
            shift = At.Shift.AFTER), cancellable = true)
    private void onPlayerInteractBlock(class_2885 packet, CallbackInfo ci) {
        // for placing blocks
        if (!hasClientMod && wasFrozen) {
            class_3244 handler = ((class_3244)(Object)this);
            class_2338 pos = packet.method_12543().method_17777();
            updateSequence(packet.method_42080()); // sequence is checked in handler.tick(), so must update it else client won't process block updates
            player.method_14234(); // to avoid potential erroneous idle timeout
            handler.method_14364(new class_2626(player.method_51469(), pos));
            handler.method_14364(new class_2626(player.method_51469(), pos.method_10093(packet.method_12543().method_17780())));
            ci.cancel();
        }
    }

    @Inject(method = "onPlayerAction", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V",
            shift = At.Shift.AFTER), cancellable = true)
    private void onPlayerAction(class_2846 packet, CallbackInfo ci) {
        // for breaking blocks
        if (!hasClientMod && wasFrozen) {
            updateSequence(packet.method_42079());
            player.method_14234();
            ((class_3244)(Object)this).method_14364(new class_2626(player.method_51469(), packet.method_12362()));
            ci.cancel();
        }
    }

    @Inject(method = "onPlayerMove", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V",
            shift = At.Shift.AFTER), cancellable = true)
    private void onPlayerMove(class_2828 packet, CallbackInfo ci) {
        if (!hasClientMod && wasFrozen) {
            requestTeleport(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
            ci.cancel();
        }
    }

}
