/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.mixin.client.render;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.TickProgressInfo;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import io.github.dennisochulor.tickrate.injected_interface.TickRateRenderTickCounter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_9779.class_9781.class})
public class RenderTickCounterDynamicMixin
implements TickRateRenderTickCounter {
    @Shadow
    private long field_51962;
    @Shadow
    private float field_51959;
    @Shadow
    @Final
    private float field_51964;
    @Unique
    private long lastLastTimeMillis;
    @Unique
    private float lastTickProgress;
    @Unique
    private int movingI;
    @Unique
    private int i;
    @Unique
    private final Map<Integer, TickProgressInfo> prevTickProgress = new HashMap<Integer, TickProgressInfo>();
    @Unique
    private final Set<Integer> isUpdated = new HashSet<Integer>();
    @Unique
    private TickProgressInfo clientPlayerTickProgressInfo = TickProgressInfo.NO_ANIMATE;
    @Unique
    private boolean clientPlayerUpdated = false;

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="HEAD")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        this.lastLastTimeMillis = this.field_51962;
        this.lastTickProgress = this.field_51959;
        this.isUpdated.clear();
        this.clientPlayerUpdated = false;
    }

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="TAIL")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir, @Local int i) {
        this.i = i;
        TickRateClientManager.clearCache();
    }

    @Override
    @Unique
    public TickProgressInfo tickRate$getSpecificTickProgressInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.isUpdated.contains(tps)) {
            return this.prevTickProgress.get(tps);
        }
        float dynamicDeltaTicks = (float)(this.field_51962 - this.lastLastTimeMillis) / Math.max(millisPerTick, this.field_51964);
        float specificTickProgress = this.prevTickProgress.getOrDefault(tps, new TickProgressInfo(this.lastTickProgress, 0, 0.0f)).tickProgress() + dynamicDeltaTicks;
        int i = (int)specificTickProgress;
        TickProgressInfo info = new TickProgressInfo(specificTickProgress -= (float)i, i, dynamicDeltaTicks);
        this.isUpdated.add(tps);
        this.prevTickProgress.put(tps, info);
        return info;
    }

    @Override
    @Unique
    public TickProgressInfo tickRate$getClientPlayerTickProgressInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.clientPlayerUpdated) {
            return this.clientPlayerTickProgressInfo;
        }
        float dynamicDeltaTicks = (float)(this.field_51962 - this.lastLastTimeMillis) / millisPerTick;
        float specificTickProgress = this.clientPlayerTickProgressInfo.tickProgress() + dynamicDeltaTicks;
        int i = (int)specificTickProgress;
        this.clientPlayerTickProgressInfo = new TickProgressInfo(specificTickProgress -= (float)i, i, dynamicDeltaTicks);
        this.clientPlayerUpdated = true;
        return this.clientPlayerTickProgressInfo;
    }

    @Override
    public void tickRate$setMovingI(int newI) {
        this.movingI = newI;
    }

    @Override
    public int tickRate$getMovingI() {
        return this.movingI;
    }

    @Override
    public int tickRate$getI() {
        return this.i;
    }
}

