/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.test;

import io.github.dennisochulor.tickrate.TickRate;
import io.github.dennisochulor.tickrate.api.TickRateAPI;
import io.github.dennisochulor.tickrate.api.TickRateEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;

public final class Test {
    private static boolean registered = false;

    private Test() {
    }

    public static void test(MinecraftServer server) {
        Test.register();
        Thread.ofVirtual().name("TickRateTest Thread").start(() -> {
            TickRateAPI api = TickRateAPI.getInstance();
            class_2168 src = server.method_3739();
            class_2170 commander = server.method_3734();
            TickRate.LOGGER.info("STARTING TICKRATE **API** SERVER TEST");
            Test.sleep(5);
            api.rateServer(10.0f);
            TickRate.LOGGER.info("{} TPS", (Object)Float.valueOf(api.queryServer()));
            Test.sleep(2);
            api.freezeServer(true);
            Test.sleep(2);
            api.stepServer(50);
            Test.sleep(7);
            api.stepServer(10000);
            Test.sleep(2);
            api.stepServer(0);
            Test.sleep(2);
            api.sprintServer(1000000);
            Test.sleep(5);
            api.sprintServer(0);
            Test.sleep(2);
            api.freezeServer(false);
            Test.sleep(2);
            api.rateServer(20.0f);
            Test.sleep(2);
            TickRate.LOGGER.info("FINISH TICKRATE **API** SERVER TEST");
            Test.sleep(2);
            TickRate.LOGGER.info("STARTING TICKRATE **COMMAND** SERVER TEST");
            Test.sleep(5);
            commander.method_44252(src, "tick rate 10");
            commander.method_44252(src, "tick query");
            Test.sleep(2);
            commander.method_44252(src, "tick freeze");
            Test.sleep(2);
            commander.method_44252(src, "tick step 50");
            Test.sleep(7);
            commander.method_44252(src, "tick step 10000");
            Test.sleep(2);
            commander.method_44252(src, "tick step stop");
            Test.sleep(2);
            commander.method_44252(src, "tick sprint 1000000");
            Test.sleep(5);
            commander.method_44252(src, "tick sprint stop");
            Test.sleep(2);
            commander.method_44252(src, "tick unfreeze");
            Test.sleep(2);
            commander.method_44252(src, "tick rate 20");
            Test.sleep(2);
            TickRate.LOGGER.info("FINISH TICKRATE **COMMAND** SERVER TEST");
        });
    }

    public static void test(class_1297 testEntity) {
        Test.register();
        Thread.ofVirtual().name("TickRateTest Thread").start(() -> {
            TickRateAPI api = TickRateAPI.getInstance();
            String uuid = testEntity.method_5845();
            class_1937 world = testEntity.method_73183();
            class_2168 src = world.method_8503().method_3739();
            class_2170 commander = world.method_8503().method_3734();
            class_1923 chunkPos = testEntity.method_31476();
            String strChunkPos = chunkPos.method_33940() + " " + chunkPos.method_33942();
            TickRate.LOGGER.info("STARTING TICKRATE **API** TEST");
            Test.sleep(5);
            TickRate.LOGGER.info("ENTITY TEST");
            api.rateEntity(testEntity, 10.0f);
            TickRate.LOGGER.info("{} TPS", (Object)Float.valueOf(api.queryEntity(testEntity)));
            Test.sleep(2);
            api.freezeEntity(testEntity, true);
            Test.sleep(2);
            api.stepEntity(testEntity, 50);
            Test.sleep(7);
            api.stepEntity(testEntity, 10000);
            Test.sleep(2);
            api.stepEntity(testEntity, 0);
            Test.sleep(2);
            api.sprintEntity(testEntity, 1000000);
            Test.sleep(5);
            api.sprintEntity(testEntity, 0);
            Test.sleep(2);
            api.freezeEntity(testEntity, false);
            Test.sleep(2);
            api.rateEntity(testEntity, 0.0f);
            Test.sleep(5);
            TickRate.LOGGER.info("CHUNK TESTS");
            api.rateChunk(world, chunkPos, 50.0f);
            TickRate.LOGGER.info("{} TPS", (Object)Float.valueOf(api.queryChunk(world, chunkPos)));
            Test.sleep(2);
            api.freezeChunk(world, chunkPos, true);
            Test.sleep(2);
            api.stepChunk(world, chunkPos, 250);
            Test.sleep(7);
            api.stepChunk(world, chunkPos, 10000);
            Test.sleep(2);
            api.stepChunk(world, chunkPos, 0);
            Test.sleep(2);
            api.sprintChunk(world, chunkPos, 1000000);
            Test.sleep(5);
            api.sprintChunk(world, chunkPos, 0);
            Test.sleep(2);
            api.freezeChunk(world, chunkPos, false);
            Test.sleep(2);
            api.rateChunk(world, chunkPos, 0.0f);
            Test.sleep(2);
            TickRate.LOGGER.info("FINISH TICKRATE **API** TEST");
            Test.sleep(2);
            TickRate.LOGGER.info("STARTING TICKRATE **COMMAND** TEST");
            Test.sleep(5);
            TickRate.LOGGER.info("ENTITY TEST");
            commander.method_44252(src, "tick entity " + uuid + " rate 10");
            commander.method_44252(src, "tick entity " + uuid + " query");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " freeze");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " step 50");
            Test.sleep(7);
            commander.method_44252(src, "tick entity " + uuid + " step 10000");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " step stop");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " sprint 1000000");
            Test.sleep(5);
            commander.method_44252(src, "tick entity " + uuid + " sprint stop");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " unfreeze");
            Test.sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " rate reset");
            Test.sleep(5);
            TickRate.LOGGER.info("CHUNK TESTS");
            commander.method_44252(src, "tick chunk " + strChunkPos + " rate 50");
            commander.method_44252(src, "tick chunk " + strChunkPos + " query");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " freeze");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " step 250");
            Test.sleep(7);
            commander.method_44252(src, "tick chunk " + strChunkPos + " step 10000");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " step stop");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " sprint 1000000");
            Test.sleep(5);
            commander.method_44252(src, "tick chunk " + strChunkPos + " sprint stop");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " unfreeze");
            Test.sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " rate reset");
            Test.sleep(2);
            TickRate.LOGGER.info("FINISH TICKRATE **COMMAND** TEST");
        });
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void register() {
        if (!registered) {
            TickRateEvents.SERVER_RATE.register((server, rate) -> TickRate.LOGGER.info("server rate {}", (Object)Float.valueOf(rate)));
            TickRateEvents.SERVER_FREEZE.register((server, freeze) -> TickRate.LOGGER.info("server freeze {}", (Object)freeze));
            TickRateEvents.SERVER_STEP.register((server, stepTicks) -> TickRate.LOGGER.info("server step {}", (Object)stepTicks));
            TickRateEvents.SERVER_SPRINT.register((server, sprintTicks) -> TickRate.LOGGER.info("server sprint {}", (Object)sprintTicks));
            TickRateEvents.ENTITY_RATE.register((entity, rate) -> TickRate.LOGGER.info("{} rate {}", (Object)entity.method_5845(), (Object)Float.valueOf(rate)));
            TickRateEvents.ENTITY_FREEZE.register((entity, freeze) -> TickRate.LOGGER.info("{} freeze {}", (Object)entity.method_5845(), (Object)freeze));
            TickRateEvents.ENTITY_STEP.register((entity, stepTicks) -> TickRate.LOGGER.info("{} step {}", (Object)entity.method_5845(), (Object)stepTicks));
            TickRateEvents.ENTITY_SPRINT.register((entity, sprintTicks) -> TickRate.LOGGER.info("{} sprint {}", (Object)entity.method_5845(), (Object)sprintTicks));
            TickRateEvents.CHUNK_RATE.register((chunk, rate) -> TickRate.LOGGER.info("{} {} rate {}", new Object[]{chunk.method_12200().method_27983().method_29177(), chunk.method_12004(), Float.valueOf(rate)}));
            TickRateEvents.CHUNK_FREEZE.register((chunk, freeze) -> TickRate.LOGGER.info("{} {} freeze {}", new Object[]{chunk.method_12200().method_27983().method_29177(), chunk.method_12004(), freeze}));
            TickRateEvents.CHUNK_STEP.register((chunk, stepTicks) -> TickRate.LOGGER.info("{} {} step {}", new Object[]{chunk.method_12200().method_27983().method_29177(), chunk.method_12004(), stepTicks}));
            TickRateEvents.CHUNK_SPRINT.register((chunk, sprintTicks) -> TickRate.LOGGER.info("{} {} sprint {}", new Object[]{chunk.method_12200().method_27983().method_29177(), chunk.method_12004(), sprintTicks}));
            registered = true;
        }
    }
}

